/*
 * Copyright (c) 2014-2019, Deepspring Healthcare Inc. All rights reserved.
 */

package com.github.azbh111.utils.java.web.model;

import lombok.ToString;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 *
 */
@ToString
public class PageRes implements Serializable {

    private static final long serialVersionUID = 6651465557869822304L;
    protected int totalCount = 0;
    /**
     * 简单的返回参数放这里面,避免多写一个类
     */
    protected Map<String, Object> extra;

    public int getTotalCount() {
        return totalCount;
    }

    public PageRes setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public Map<String, Object> getExtra() {
        return extra;
    }

    public PageRes setExtra(Map<String, Object> extra) {
        this.extra = extra;
        return this;
    }

    /**
     * 设置额外参数
     *
     * @param key
     * @param value
     * @return
     */
    public PageRes setExtra(String key, Object value) {
        if (extra == null) {
            extra = new LinkedHashMap<>();
        }
        extra.put(key, value);
        return this;
    }

}