/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect.model;

import com.github.azbh111.utils.java.reflect.ReflectUtils;
import com.github.azbh111.utils.java.reflect.model.CommonFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public class FieldFilter
extends CommonFilter<FieldFilter>
implements Predicate<Field> {
    private Class type;
    private Boolean static_;
    private Boolean final_;
    private Integer index;

    private FieldFilter() {
    }

    public static FieldFilter create() {
        return new FieldFilter();
    }

    public Class getType() {
        return this.type;
    }

    public FieldFilter setType(Class type) {
        this.type = type;
        return this;
    }

    public Boolean getStatic() {
        return this.static_;
    }

    public FieldFilter setStatic(Boolean static_) {
        this.static_ = static_;
        return this;
    }

    public Boolean getFinal() {
        return this.final_;
    }

    public FieldFilter setFinal(Boolean final_) {
        this.final_ = final_;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public FieldFilter setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Override
    public boolean test(Field wf) {
        if (this.static_ != null && this.static_ != Modifier.isStatic(wf.getModifiers())) {
            return false;
        }
        if (this.final_ != null && this.final_ != Modifier.isFinal(wf.getModifiers())) {
            return false;
        }
        if (!super.filter(wf.getName())) {
            return false;
        }
        if (this.type != null && wf.getType() != this.type) {
            return false;
        }
        return this.getAnnotationType() == null || ReflectUtils.findAnnotation(wf, this.getAnnotationType()) != null;
    }

    public String toString() {
        return "FieldFilter(super=" + super.toString() + ", type=" + this.getType() + ", static_=" + this.static_ + ", final_=" + this.final_ + ", index=" + this.getIndex() + ")";
    }
}

