/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect.model;

import com.github.azbh111.utils.java.reflect.ReflectUtils;
import com.github.azbh111.utils.java.reflect.model.CommonFilter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Predicate;

public class MethodFilter
extends CommonFilter<MethodFilter>
implements Predicate<Method> {
    private Class[] returnType;
    private Class[] parameterType;
    private Boolean static_;
    private Boolean final_;
    private Integer index;
    private Boolean abstract_;

    private MethodFilter() {
    }

    public static MethodFilter create() {
        return new MethodFilter();
    }

    public Class[] getReturnType() {
        return this.returnType;
    }

    public MethodFilter setReturnType(Class ... returnType) {
        this.returnType = returnType;
        return this;
    }

    public Class[] getParameterType() {
        return this.parameterType;
    }

    public MethodFilter setParameterType(Class[] parameterType) {
        this.parameterType = parameterType;
        return this;
    }

    public Boolean getStatic() {
        return this.static_;
    }

    public MethodFilter setStatic(Boolean static_) {
        this.static_ = static_;
        return this;
    }

    public Boolean getFinal() {
        return this.final_;
    }

    public MethodFilter setFinal(Boolean final_) {
        this.final_ = final_;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public MethodFilter setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public Boolean getAbstract() {
        return this.abstract_;
    }

    public MethodFilter setAbstract(Boolean abstract_) {
        this.abstract_ = abstract_;
        return this;
    }

    @Override
    public boolean test(Method wm) {
        if (this.abstract_ != null && this.abstract_ != Modifier.isAbstract(wm.getModifiers())) {
            return false;
        }
        if (this.static_ != null && this.static_ != Modifier.isStatic(wm.getModifiers())) {
            return false;
        }
        if (this.final_ != null && this.final_ != Modifier.isFinal(wm.getModifiers())) {
            return false;
        }
        if (!super.filter(wm.getName())) {
            return false;
        }
        if (this.returnType != null) {
            Class<?> realReturnType = wm.getReturnType();
            if (this.returnType.length == 0 ? realReturnType != Void.TYPE : !this.match(this.returnType, item -> item == realReturnType)) {
                return false;
            }
        }
        if (this.parameterType != null) {
            Class<?>[] params = wm.getParameterTypes();
            if (params.length != this.parameterType.length) {
                return false;
            }
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                if (params[i] == this.parameterType[i]) continue;
                return false;
            }
        }
        return this.getAnnotationType() == null || ReflectUtils.findAnnotation(wm, this.getAnnotationType()) != null;
    }

    public String toString() {
        return "MethodFilter(super=" + super.toString() + ", returnType=" + Arrays.deepToString(this.getReturnType()) + ", parameterType=" + Arrays.deepToString(this.getParameterType()) + ", static_=" + this.static_ + ", final_=" + this.final_ + ", index=" + this.getIndex() + ", abstract_=" + this.abstract_ + ")";
    }
}

