/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.spi;

import com.github.azbh111.utils.java.predicate.PredicateUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;

public class SPIUtils {
    private static final String PREFIX = "META-INF/services/";

    public static <T> ServiceLoader<T> load(Class<T> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <T> ServiceLoader<T> load(Class<T> service, ClassLoader classLoader) {
        return ServiceLoader.load(service, classLoader);
    }

    public static <T> ServiceLoader<T> loadInstalled(Class<T> service) {
        return ServiceLoader.loadInstalled(service);
    }

    public static <T> List<Class<? extends T>> loadClass(Class<T> service) {
        return SPIUtils.loadClass(service, Thread.currentThread().getContextClassLoader());
    }

    public static <T> List<Class<? extends T>> loadClass(Class<T> service, ClassLoader classLoader) {
        try {
            String fullName = PREFIX + service.getName();
            Enumeration<URL> configs = null;
            configs = classLoader == null ? ClassLoader.getSystemResources(fullName) : classLoader.getResources(fullName);
            if (configs == null) {
                return new ArrayList<Class<? extends T>>();
            }
            Predicate<String> test = PredicateUtils.distinctBy(Function.identity());
            ArrayList<String> services = new ArrayList<String>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                for (String s : SPIUtils.parse(service, url)) {
                    if (!test.test(s)) continue;
                    services.add(s);
                }
            }
            ArrayList<Class<T>> classes = new ArrayList<Class<T>>(services.size());
            Class<?> c = null;
            for (String s : services) {
                try {
                    c = Class.forName(s, true, classLoader);
                }
                catch (ClassNotFoundException x) {
                    SPIUtils.fail(service, "Provider " + s + " not found");
                }
                if (!service.isAssignableFrom(c)) {
                    SPIUtils.fail(service, "Provider " + s + " not a subtype");
                }
                classes.add(c);
            }
            return classes;
        }
        catch (IOException x) {
            throw new ServiceConfigurationError(service.getName() + ": Error locating configuration files", x);
        }
    }

    private static List<String> parse(Class<?> service, URL u) throws ServiceConfigurationError, IOException {
        ArrayList<String> names = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));){
            int lc = 1;
            while ((lc = SPIUtils.parseLine(service, u, reader, lc, names)) >= 0) {
            }
        }
        return names;
    }

    private static int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                SPIUtils.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                SPIUtils.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                SPIUtils.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            names.add(ln);
        }
        return lc + 1;
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        SPIUtils.fail(service, u + ":" + line + ": " + msg);
    }
}

