package com.github.azbh111.utils.java.csv;

/**
 * @author: zyp
 * @date: 2020/12/4 17:44
 */

import java.lang.annotation.*;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.METHOD})
public @interface CsvColumn {
    /**
     * 列名
     */
    String value();

    /**
     * 列顺序
     * 升序排列
     */
    int order() default 0;

    /**
     * 对 Date/LocalDate/LocalDateTime/... 等时间/日期字段 执行格式化操作
     * 对 Float/Double 小数字段执行格式化操作
     * 优先级高于conventor
     */
    String format() default "";

    /**
     * 如果值为null, 使用这个值进行导出
     */
    String nullValue() default "";
}
