package com.github.azbh111.utils.java.csv;

import com.github.azbh111.utils.java.datetime.DateTimeUtils;
import com.github.azbh111.utils.java.reflect.ReflectUtils;
import lombok.Getter;
import lombok.ToString;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

/**
 * @author: zyp
 * @date: 2020/12/4 18:24
 */
@Getter
@ToString(callSuper = true)
public class CsvExporterTask<T> {
    private final Class<T> cls;
    private final List<CsvColumnDefine> columns;
    private final BufferedWriter writer;
    private final CsvExporter exporter;

    public CsvExporterTask(CsvExporter exporter, Class<T> cls, OutputStream outputStream) {
        this(exporter, cls, new BufferedWriter(new OutputStreamWriter(outputStream, exporter.getCharset())));
    }

    public CsvExporterTask(CsvExporter exporter, Class<T> cls, Writer writer) {
        this.exporter = exporter;
        this.cls = cls;
        this.writer = new BufferedWriter(writer);
        this.columns = exporter.getColumns(cls);
    }

    public CsvExporterTask put(List<T> batchList) {
        return put(batchList.iterator());
    }

    public CsvExporterTask put(Iterator<T> batchList) {
        try {
            while (batchList.hasNext()) {
                Object item = batchList.next();
                boolean writeComma = false;
                for (CsvColumnDefine column : columns) {
                    if (writeComma) {
                        writer.write(",");
                    }
                    writeComma = true;
                    Object value = column.get(item);
                    String str = value == null ? column.getNullValue() : column.getConventor().apply(value);
                    writeCell(str, writer);
                }
                writer.newLine();
            }
        } catch (Throwable x) {
            throw new RuntimeException(x);
        }
        return this;
    }

    public CsvExporterTask start() {
        try {

//        写头
            boolean writeComma = false;
            for (CsvColumnDefine column : columns) {
                if (writeComma) {
                    writer.write(",");
                }
                writeComma = true;
                writeCell(column.getName(), writer);
            }
            writer.newLine();
        } catch (Throwable x) {
            throw new RuntimeException(x);
        }
        return this;
    }

    private void writeCell(String value, BufferedWriter output) throws IOException {
        output.write("\"");
        output.write(value.replaceAll("\"", "\"\""));
        output.write("\"");
    }

    public CsvExporterTask finish() {
        try {
            writer.close();
        } catch (Throwable x) {
            throw new RuntimeException(x);
        }
        return this;
    }

}
