package com.github.azbh111.utils.java.function;

import com.github.azbh111.utils.java.string.StringUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

/**
 * @author pyz
 * @date 2019/3/30 3:56 PM
 */
public class Generator {
    String template = "package lol.clann.utils.base.function;\n" +
            "\n" +
            "/**\n" +
            " *\n" +
            " * @author pyz\n" +
            " * @date 2019/3/11 8:43 PM\n" +
            " */\n" +
            "@FunctionalInterface\n" +
            "public interface {usrc}2{utarget}Function{suffix} {\n" +
            "    {returnType} apply({parameterType} in);\n" +
            "}\n";
    List<String> types = new ArrayList<>();
    Path dir = Paths.get(System.getProperty("user.dir") + "/src/main/java/lol/clann/utils/function");

    {
        types.add(byte.class.getSimpleName());
        types.add(short.class.getSimpleName());
        types.add(int.class.getSimpleName());
        types.add(long.class.getSimpleName());
        types.add(float.class.getSimpleName());
        types.add(double.class.getSimpleName());
        types.add(boolean.class.getSimpleName());
        types.add(char.class.getSimpleName());
        types.add(Object.class.getSimpleName());
    }

    public static void main(String[] args) throws IOException {
        new Generator().run();
    }

    private void run() throws IOException {
        for (String src : types) {
            for (String target : types) {
                if (src.equals("Object") && target.equals("Object")) {
                    continue;
                }
                generate(src, target);
            }
        }
    }

    private void generate(String src, String target) throws IOException {
        String usrc = upperCaseFirstCharacter(src);
        String utarget = upperCaseFirstCharacter(target);
        String suffix = usrc.equals("Object") || utarget.equals("Object") ? "<T>" : "";
        String returnType = utarget.equals("Object") ? "T" : target;
        String parameterType = usrc.equals("Object") ? "T" : src;
        String fileName = "{usrc}2{utarget}Function".replace("{usrc}", usrc).replace("{utarget}", utarget) + ".java";
        String content = template.replace("{usrc}", usrc)
                .replace("{utarget}", utarget)
                .replace("{suffix}", suffix)
                .replace("{returnType}", returnType)
                .replace("{parameterType}", parameterType);
        Path file = dir.resolve(fileName);
        if (!Files.exists(file)) {
            List<String> list = new ArrayList<>();
            list.add(content);
            Files.write(file, list, StandardOpenOption.CREATE_NEW);
        }
    }


    /**
     * 首字母大写
     *
     * @param str
     * @return
     */
    public static String upperCaseFirstCharacter(String str) {
        return changeFirstLetter(str, 1);
    }

    /**
     * 首字母小写
     *
     * @param str
     * @return
     */
    public static String lowerCaseFirstCharacter(String str) {
        return changeFirstLetter(str, -1);
    }


    /**
     * 直接用给定的char数组生成String,不做拷贝
     *
     * @param chars
     * @return
     */
    public static String newStringUnsafe(char[] chars) {
        return StringUtils.newStringZeroCopy(chars);
    }

    private static String changeFirstLetter(String str, int flag) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        if (flag == 1) {
            chars[0] = Character.toUpperCase(chars[0]);
        } else if (flag == -1) {
            chars[0] = Character.toLowerCase(chars[0]);
        }
        String r = newStringUnsafe(chars);
        return r;
    }
}
