package com.github.azbh111.utils.java.math.matrix.model;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

/**
 * 基于BitSet的二维boolean矩阵
 *
 * @author pyz
 * @date 2019/4/13 3:44 PM
 */
public class BooleanMatrix2 {

    private int with;
    private int height;
    private BitSet[] matrix2;

    public BooleanMatrix2(int with, int height) {
        this.with = with;
        this.height = height;
        matrix2 = new BitSet[with];
        for (int i = 0; i < with; i++) {
            matrix2[i] = new BitSet(height);
        }
    }

    public int getWith() {
        return with;
    }

    public void setWith(int with) {
        this.with = with;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isOn(int w, int h) {
        return get(w, h);
    }

    public boolean isOff(int w, int h) {
        return !get(w, h);
    }

    public boolean setOnIfOff(int w, int h) {
        if (isOff(w, h)) {
            setOn(w, h);
            return true;
        }
        return false;
    }

    public boolean setOffIfOn(int w, int h) {
        if (isOn(w, h)) {
            setOff(w, h);
            return true;
        }
        return false;
    }

    public BooleanMatrix2 setOn(int w, int h) {
        check(w, h);
        matrix2[w].set(h);
        return this;
    }

    public BooleanMatrix2 setOff(int w, int h) {
        check(w, h);
        matrix2[w].clear(h);
        return this;
    }

    public BooleanMatrix2 set(int w, int h, int status) {
        if (status != 0) {
            return setOn(w, h);
        } else {
            return setOff(w, h);
        }
    }

    public boolean get(int w, int h) {
        check(w, h);
        return matrix2[w].get(h);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BooleanMatrix2 matrix21 = (BooleanMatrix2) o;
        return with == matrix21.with &&
                height == matrix21.height &&
                Arrays.equals(matrix2, matrix21.matrix2);
    }

    @Override
    public int hashCode() {

        int result = Objects.hash(with, height);
        result = 31 * result + Arrays.hashCode(matrix2);
        return result;
    }

    private void check(int w, int h) {
        if (w >= with) {
            throw new IndexOutOfBoundsException(with + "," + w);
        }
        if (h >= height) {
            throw new IndexOutOfBoundsException(height + "," + h);
        }
    }
}
