/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.math.prime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PrimeGenerator
implements Iterator<Integer> {
    private static final int[] staticPrimeCache = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31};
    private static final int staticCacheSize = staticPrimeCache.length;
    private static final int zeroCandidate;
    private static final Skip skips;
    private Skip skip;
    private int cacheSize;
    private final List<Integer> primeCache;
    private int count = 0;
    private int candidate;

    public PrimeGenerator() {
        this(16);
    }

    public PrimeGenerator(int cacheSize) {
        if (cacheSize < 0) {
            throw new IllegalArgumentException(cacheSize + "");
        }
        this.cacheSize = cacheSize;
        this.primeCache = new ArrayList<Integer>(cacheSize);
        this.candidate = zeroCandidate;
        this.skip = skips;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Integer next() {
        return this.nextInt();
    }

    public int count() {
        return this.count;
    }

    public int nextInt() {
        if (this.count < staticCacheSize) {
            return staticPrimeCache[this.count++];
        }
        this.candidate += this.skip.skip;
        this.skip = skips.next;
        while (!this.isPrime(this.candidate)) {
            this.candidate += this.skip.skip;
            this.skip = skips.next;
        }
        this.cache1(this.candidate);
        ++this.count;
        return this.candidate;
    }

    private boolean isPrime(int number) {
        if ((number & 1) == 0) {
            return false;
        }
        int ratio = staticPrimeCache[1];
        if (number % ratio == 0) {
            return false;
        }
        int top = (int)Math.sqrt(number);
        if (top * top == number) {
            return false;
        }
        for (int i = 2; i < staticPrimeCache.length; ++i) {
            ratio = staticPrimeCache[i];
            if (ratio > top) {
                return true;
            }
            if (number % ratio != 0) continue;
            return false;
        }
        for (Integer integer : this.primeCache) {
            ratio = integer;
            if (ratio > top) {
                return true;
            }
            if (number % integer != 0) continue;
            return false;
        }
        for (ratio = this.primeCache.get(this.primeCache.size() - 1) + 2; ratio <= top; ratio += 2) {
            if (number % ratio != 0) continue;
            return false;
        }
        return true;
    }

    private void cache1(int prime) {
        if (staticPrimeCache[staticCacheSize - 1] < prime && this.primeCache.size() < this.cacheSize) {
            this.primeCache.add(prime);
        }
    }

    static {
        int grow = (staticPrimeCache[staticPrimeCache.length - 1] - 1) % 3 == 0 ? 4 : 2;
        zeroCandidate = staticPrimeCache[staticPrimeCache.length - 1];
        skips = new Skip();
        skips.skip = grow;
        skips.next = new Skip();
        skips.next.skip = 6 - grow;
        skips.next.next = PrimeGenerator.skips;
    }

    private static class Skip {
        private int skip;
        private Skip next;

        private Skip() {
        }
    }
}

