/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.url;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;

public class UrlUtils {
    public static String removeHost(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        if (!url.startsWith("http")) {
            if (url.indexOf("/") == 0) {
                return url.substring(1);
            }
            return url;
        }
        int idx = (url = url.replace("http://", "").replace("https://", "")).indexOf("/");
        if (idx == -1) {
            return "";
        }
        return url.substring(idx + 1);
    }

    public static String getHost(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("http://")) {
            url = url.substring("http://".length());
        } else if (url.startsWith("https://")) {
            url = url.substring("https://".length());
        } else {
            return null;
        }
        if (url.isEmpty()) {
            return null;
        }
        int dot = url.indexOf(47);
        if (dot == -1) {
            return url;
        }
        if (dot == 0) {
            return null;
        }
        return url.substring(0, dot);
    }

    public static String getFileSuffix(String url) {
        if (url == null) {
            return null;
        }
        int dot = url.indexOf("//");
        if (dot == -1) {
            return "";
        }
        int dot2 = url.lastIndexOf(47);
        if (dot2 == dot + 1) {
            return "";
        }
        int dot3 = url.lastIndexOf(46);
        if (dot3 < dot2) {
            return "";
        }
        return url.substring(dot3 + 1);
    }

    public static String urlEncode(String url) {
        return UrlUtils.urlEncode(url, Charset.defaultCharset());
    }

    public static String urlEncode(String url, Charset encoding) {
        try {
            return URLEncoder.encode(url, encoding.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlDecode(String url) {
        return UrlUtils.urlDecode(url, Charset.defaultCharset());
    }

    public static String urlDecode(String url, Charset encoding) {
        try {
            return URLDecoder.decode(url, encoding.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

