package com.github.azbh111.utils.java.exception;

/**
 * 嵌套异常
 *
 * @author pyz
 * @date 2018/12/14 11:15 AM
 */
public class NestedException extends RuntimeException {

    private static final long serialVersionUID = -6931277782260791958L;

    public NestedException(String message, Throwable cause) {
        super(message, cause);
    }

    public NestedException(Throwable cause) {
        super(cause);
    }

    @Override
    public String toString() {
        if (getCause() == null) {
            return super.toString();
        }
        final StringBuilder sb = new StringBuilder(64);
        sb.append(getMessage());
        sb.append(";nested exceptions is ").append(getCause().getMessage());
        return super.toString();
    }
}
