package com.github.azbh111.utils.java.math.permutation;

/**
 *
 * @author pyz
 * @date 2019/4/14 11:14 AM
 */
public abstract class PermutationHolder {

    /**
     * 比较两个位置元素大小
     *
     * @param i
     * @param j
     * @return
     */
    public abstract int compare(int i, int j);

    /**
     * 交换指定位置的两个元素
     *
     * @param i
     * @param j
     */
    public abstract void swap(int i, int j);

    /**
     * 颠倒[fromIndex,toIndex)范围内的数据
     *
     * @param fromIndex
     * @param toIndex
     */
    public abstract void reverse(int fromIndex, int toIndex);

    public abstract int length();

    /**
     * 返回字典序的下一个排列
     * 源自c++标准库STL
     * @return
     */
    public boolean nextPermutation() {
        int size = length();
        for (int right = size - 1; right > 0; --right) {
            int left = right - 1;
            //找到第二个划分与第一个划分的分界线
            if (compare(left, right) < 0) {
                int j = size - 1;
                //找到第一大于leftValue值的位置
                for (; j >= right; --j) {
                    if (compare(left, j) < 0) {
                        break;
                    }
                }
                //交换val值和第一个大于val的值
                swap(left, j);
                //逆序处理
                reverse(right, size);
                return true;
            }
        }
        return false;
    }

    /**
     * 返回字典序的上一个排列
     * 源自c++标准库STL
     * @return
     */
    public boolean prePermutation() {
        int size = length();
        for (int right = size - 1; right > 0; --right) {
            int left = right - 1;
            if (compare(left, right) > 0) {
                int j = size - 1;
                for (; j >= right; --j) {
                    if (compare(left, j) > 0) {
                        break;
                    }
                }
                swap(left, j);
                reverse(right, size);
                return true;
            }
        }
        return false;
    }

}
