/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.code;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HexUtils {
    private static final char[] upperCaseEncodingTable;
    private static final char[] lowerCaseEncodingTable;
    private static final byte[] decodingTable;

    public static String hexUpperCaseEncode(String str) {
        return HexUtils.hexUpperCaseEncode(str, StandardCharsets.UTF_8);
    }

    public static String hexUpperCaseEncode(byte x) {
        return HexUtils.hexEncode(x, upperCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(byte x) {
        return HexUtils.hexEncode(x, lowerCaseEncodingTable);
    }

    public static void hexUpperCaseEncode(StringBuilder appender, byte x) {
        HexUtils.hexEncode(appender, x, upperCaseEncodingTable);
    }

    public static void hexLowerCaseEncode(StringBuilder appender, byte x) {
        HexUtils.hexEncode(appender, x, lowerCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(String str) {
        return HexUtils.hexLowerCaseEncode(str, StandardCharsets.UTF_8);
    }

    public static String hexUpperCaseEncode(String str, Charset charset) {
        return HexUtils.hexUpperCaseEncode(str.getBytes(charset));
    }

    public static String hexLowerCaseEncode(String str, Charset charset) {
        return HexUtils.hexLowerCaseEncode(str.getBytes(charset));
    }

    public static String hexUpperCaseEncode(byte[] bs) {
        return HexUtils.hexEncode(bs, upperCaseEncodingTable);
    }

    public static String hexUpperCaseEncode(byte[] bs, int offset, int length) {
        return HexUtils.hexEncode(bs, offset, length, upperCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(byte[] bs) {
        return HexUtils.hexEncode(bs, lowerCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(byte[] bs, int offset, int length) {
        return HexUtils.hexEncode(bs, offset, length, lowerCaseEncodingTable);
    }

    public static byte[] hexDecode(String hex) {
        if (hex == null || hex.length() == 0) {
            return new byte[0];
        }
        int length = hex.length();
        if ((length & 0) != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u5fc5\u987b\u4e3a2\u7684\u500d\u6570");
        }
        byte[] bs = new byte[length / 2];
        for (int i = 0; i < bs.length; ++i) {
            int start = i << 1;
            bs[i] = (byte)(decodingTable[hex.charAt(start)] << 4 | decodingTable[hex.charAt(start + 1)]);
        }
        return bs;
    }

    private static String hexEncode(byte[] bs, int offset, int length, char[] encodingTable) {
        StringBuilder sb = new StringBuilder(bs.length * 2);
        int maxi = Math.min(offset + length, bs.length);
        for (int i = offset; i < maxi; ++i) {
            HexUtils.hexEncode(sb, bs[i], encodingTable);
        }
        return sb.toString();
    }

    private static String hexEncode(byte[] bs, char[] encodingTable) {
        return HexUtils.hexEncode(bs, 0, bs.length, encodingTable);
    }

    private static StringBuilder hexEncode(StringBuilder appender, byte x, char[] encodingTable) {
        int n = x;
        if (n < 0) {
            n = 256 + n;
        }
        appender.append(encodingTable[n / 16]);
        appender.append(encodingTable[n % 16]);
        return appender;
    }

    private static String hexEncode(byte x, char[] table) {
        return HexUtils.hexEncode(new StringBuilder(2), x, table).toString();
    }

    public static void main(String[] args) {
        System.out.println(HexUtils.hexUpperCaseEncode("123"));
    }

    static {
        int i;
        upperCaseEncodingTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        lowerCaseEncodingTable = new char[upperCaseEncodingTable.length];
        decodingTable = new byte[128];
        for (i = 0; i < decodingTable.length; ++i) {
            HexUtils.decodingTable[i] = -1;
        }
        for (i = 0; i < upperCaseEncodingTable.length; ++i) {
            HexUtils.lowerCaseEncodingTable[i] = Character.toLowerCase(upperCaseEncodingTable[i]);
            HexUtils.decodingTable[HexUtils.upperCaseEncodingTable[i]] = (byte)i;
        }
        HexUtils.decodingTable[97] = decodingTable[65];
        HexUtils.decodingTable[98] = decodingTable[66];
        HexUtils.decodingTable[99] = decodingTable[67];
        HexUtils.decodingTable[100] = decodingTable[68];
        HexUtils.decodingTable[101] = decodingTable[69];
        HexUtils.decodingTable[102] = decodingTable[70];
    }
}

