/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.reflect;

import com.github.azbh111.utils.java.exception.ExceptionUtils;
import com.github.azbh111.utils.java.reflect.ReflectUtils;
import com.github.azbh111.utils.java.reflect.model.ClassCopyDesc;
import com.github.azbh111.utils.java.reflect.model.UnsafeField;
import com.github.azbh111.utils.java.unsafe.UnsafeUtils;
import java.io.Console;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class ObjectUtils {
    private static final Set<Class> unmodifiedClass = ConcurrentHashMap.newKeySet();
    private static final Set<Class> unmodifiedClassForDeepCopy = ConcurrentHashMap.newKeySet();
    private static final Set<Class> unmodifiedClassForShallowCopy = ConcurrentHashMap.newKeySet();
    private static final Map<Class, ClassCopyDesc<?>> unsafeFieldMap = new ConcurrentHashMap();

    public static Map<String, Object> toMap(Object object) {
        return ObjectUtils.toMap(object, field -> true);
    }

    public static Map<String, Object> toMap(Object object, Predicate<Field> filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (object == null) {
            return map;
        }
        for (Field field : ReflectUtils.getAllFields(object.getClass(), filter)) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                map.put(field.getName(), field.get(object));
            }
            catch (IllegalAccessException e) {
                ExceptionUtils.throwException(e);
            }
        }
        return map;
    }

    public static void registerUnmodifiedClass(Class clazz) {
        unmodifiedClassForDeepCopy.add(clazz);
        unmodifiedClassForShallowCopy.add(clazz);
    }

    public static boolean isEnum(Object o) {
        return o instanceof Enum;
    }

    public static boolean isAnnotation(Object o) {
        return o instanceof Annotation && o instanceof Proxy && o.getClass().getSuperclass() != null && o.getClass().getSuperclass().getSuperclass() == Object.class;
    }

    public static <T> T deepCopy(T s) throws InstantiationException {
        return ObjectUtils.deepCopy(new IdentityHashMap<Object, Object>(), s);
    }

    private static <T> T deepCopy(Map<Object, Object> cache, T s) throws InstantiationException {
        if (s == null) {
            return null;
        }
        Class<?> type = s.getClass();
        if (type.isArray()) {
            Object o = cache.get(s);
            return (T)(o != null ? o : ObjectUtils.deepCopyArray(cache, s));
        }
        if (ObjectUtils.isImmutableForDeepCopy(s)) {
            return s;
        }
        Object o = cache.get(s);
        if (o != null) {
            return (T)o;
        }
        ClassCopyDesc<?> copyer = ObjectUtils.getOrParseUnsafeField(type);
        Object t = UnsafeUtils.allocateInstance(type);
        cache.put(s, t);
        for (UnsafeField unsafeField : copyer.getFields()) {
            Class fType = unsafeField.getType();
            long offset = unsafeField.getOffset();
            if (fType == Boolean.TYPE) {
                UnsafeUtils.putBoolean(t, offset, UnsafeUtils.getBoolean(s, offset));
                continue;
            }
            if (fType == Character.TYPE) {
                UnsafeUtils.putChar(t, offset, UnsafeUtils.getChar(s, offset));
                continue;
            }
            if (fType == Byte.TYPE) {
                UnsafeUtils.putByte(t, offset, UnsafeUtils.getByte(s, offset));
                continue;
            }
            if (fType == Short.TYPE) {
                UnsafeUtils.putShort(t, offset, UnsafeUtils.getShort(s, offset));
                continue;
            }
            if (fType == Integer.TYPE) {
                UnsafeUtils.putInt(t, offset, UnsafeUtils.getInt(s, offset));
                continue;
            }
            if (fType == Long.TYPE) {
                UnsafeUtils.putLong(t, offset, UnsafeUtils.getLong(s, offset));
                continue;
            }
            if (fType == Float.TYPE) {
                UnsafeUtils.putFloat(t, offset, UnsafeUtils.getFloat(s, offset));
                continue;
            }
            if (fType == Double.TYPE) {
                UnsafeUtils.putDouble(t, offset, UnsafeUtils.getDouble(s, offset));
                continue;
            }
            UnsafeUtils.putObject(t, offset, ObjectUtils.deepCopy(cache, UnsafeUtils.getObject(s, offset)));
        }
        return (T)t;
    }

    private static boolean isImmutableForDeepCopy(Object o) {
        return o instanceof Class || ObjectUtils.isEnum(o) || ObjectUtils.isAnnotation(o) || unmodifiedClass.contains(o.getClass());
    }

    private static <T> T deepCopyArray(Map<Object, Object> cache, T srcArr) throws InstantiationException {
        Class<?> component = srcArr.getClass().getComponentType();
        int length = Array.getLength(srcArr);
        Object targetArr = Array.newInstance(component, length);
        if (component.isPrimitive() || component.isEnum() || unmodifiedClass.contains(component)) {
            System.arraycopy(srcArr, 0, targetArr, 0, length);
        } else {
            Object o = cache.get(srcArr);
            if (o != null) {
                return (T)o;
            }
            for (int i = 0; i < length; ++i) {
                Array.set(targetArr, i, ObjectUtils.deepCopy(cache, Array.get(srcArr, i)));
            }
        }
        return (T)targetArr;
    }

    private static <T> ClassCopyDesc<T> getOrParseUnsafeField(Class<T> clazz) {
        ClassCopyDesc<Object> copyer = unsafeFieldMap.get(clazz);
        if (copyer == null) {
            copyer = ClassCopyDesc.of(clazz);
            unsafeFieldMap.put(clazz, copyer);
        }
        return copyer;
    }

    static {
        ObjectUtils.registerUnmodifiedClass(String.class);
        ObjectUtils.registerUnmodifiedClass(Boolean.class);
        ObjectUtils.registerUnmodifiedClass(Character.class);
        ObjectUtils.registerUnmodifiedClass(Byte.class);
        ObjectUtils.registerUnmodifiedClass(Short.class);
        ObjectUtils.registerUnmodifiedClass(Integer.class);
        ObjectUtils.registerUnmodifiedClass(Long.class);
        ObjectUtils.registerUnmodifiedClass(Float.class);
        ObjectUtils.registerUnmodifiedClass(Double.class);
        ObjectUtils.registerUnmodifiedClass(UUID.class);
        ObjectUtils.registerUnmodifiedClass(URL.class);
        ObjectUtils.registerUnmodifiedClass(URI.class);
        ObjectUtils.registerUnmodifiedClass(Class.class);
        ObjectUtils.registerUnmodifiedClass(Field.class);
        ObjectUtils.registerUnmodifiedClass(Constructor.class);
        ObjectUtils.registerUnmodifiedClass(Method.class);
        ObjectUtils.registerUnmodifiedClass(Parameter.class);
        ObjectUtils.registerUnmodifiedClass(ClassDefinition.class);
        ObjectUtils.registerUnmodifiedClass(Console.class);
        ObjectUtils.registerUnmodifiedClass(ThreadLocal.class);
    }
}

