/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;

public class ResourceUtils {
    private static final ClassLoader currentClassLoader = ResourceUtils.class.getClassLoader();
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

    public static Enumeration<URL> getResources(Class clazz, String path) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        classLoader = currentClassLoader;
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        classLoader = systemClassLoader;
        if (classLoader != null) {
            return classLoader.getResources(path);
        }
        return Collections.emptyEnumeration();
    }

    public static URL getResource(Class clazz, String path) {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader && (url = ResourceUtils.getResource(path, classLoader)) != null) {
            return url;
        }
        classLoader = clazz.getClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader && (url = ResourceUtils.getResource(path, classLoader)) != null) {
            return url;
        }
        classLoader = currentClassLoader;
        if (classLoader != null && (url = ResourceUtils.getResource(path, classLoader)) != null) {
            return url;
        }
        classLoader = systemClassLoader;
        if (classLoader != null && (url = ResourceUtils.getResource(path, classLoader)) != null) {
            return url;
        }
        return null;
    }

    public static InputStream getResourceAsStream(Class clazz, String path) {
        InputStream is;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader && (is = ResourceUtils.getResourceAsStream(path, classLoader)) != null) {
            return is;
        }
        classLoader = clazz.getClassLoader();
        if (classLoader != null && classLoader != currentClassLoader && classLoader != systemClassLoader && (is = ResourceUtils.getResourceAsStream(path, classLoader)) != null) {
            return is;
        }
        classLoader = currentClassLoader;
        if (classLoader != null && (is = ResourceUtils.getResourceAsStream(path, classLoader)) != null) {
            return is;
        }
        classLoader = systemClassLoader;
        if (classLoader != null && (is = ResourceUtils.getResourceAsStream(path, classLoader)) != null) {
            return is;
        }
        return null;
    }

    private static URL getResource(String path, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(path);
    }

    private static InputStream getResourceAsStream(String path, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResourceAsStream(path);
    }
}

