/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.unsafe;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeUtils {
    private static final Unsafe u;
    public static final long ARRAY_BOOLEAN_BASE_OFFSET;
    public static final long ARRAY_BYTE_BASE_OFFSET;
    public static final long ARRAY_SHORT_BASE_OFFSET;
    public static final long ARRAY_CHAR_BASE_OFFSET;
    public static final long ARRAY_INT_BASE_OFFSET;
    public static final long ARRAY_LONG_BASE_OFFSET;
    public static final long ARRAY_FLOAT_BASE_OFFSET;
    public static final long ARRAY_DOUBLE_BASE_OFFSET;
    public static final long ARRAY_OBJECT_BASE_OFFSET;
    public static final long ARRAY_BOOLEAN_INDEX_SCALE;
    public static final long ARRAY_BYTE_INDEX_SCALE;
    public static final long ARRAY_SHORT_INDEX_SCALE;
    public static final long ARRAY_CHAR_INDEX_SCALE;
    public static final long ARRAY_INT_INDEX_SCALE;
    public static final long ARRAY_LONG_INDEX_SCALE;
    public static final long ARRAY_FLOAT_INDEX_SCALE;
    public static final long ARRAY_DOUBLE_INDEX_SCALE;
    public static final long ARRAY_OBJECT_INDEX_SCALE;
    public static final int ADDRESS_SIZE;
    public static final int addressSize;

    public static Unsafe getInstance() {
        return u;
    }

    public static int getInt(Object o, long offset) {
        return UnsafeUtils.getInstance().getInt(o, offset);
    }

    public static void putInt(Object o, long offset, int val) {
        UnsafeUtils.getInstance().putInt(o, offset, val);
    }

    public static Object getObject(Object o, long offset) {
        return UnsafeUtils.getInstance().getObject(o, offset);
    }

    public static void putObject(Object o, long offset, Object val) {
        UnsafeUtils.getInstance().putObject(o, offset, val);
    }

    public static boolean getBoolean(Object o, long offset) {
        return UnsafeUtils.getInstance().getBoolean(o, offset);
    }

    public static void putBoolean(Object o, long offset, boolean val) {
        UnsafeUtils.getInstance().putBoolean(o, offset, val);
    }

    public static byte getByte(Object o, long offset) {
        return UnsafeUtils.getInstance().getByte(o, offset);
    }

    public static void putByte(Object o, long offset, byte val) {
        UnsafeUtils.getInstance().putByte(o, offset, val);
    }

    public static short getShort(Object o, long offset) {
        return UnsafeUtils.getInstance().getShort(o, offset);
    }

    public static void putShort(Object o, long offset, short val) {
        UnsafeUtils.getInstance().putShort(o, offset, val);
    }

    public static char getChar(Object o, long offset) {
        return UnsafeUtils.getInstance().getChar(o, offset);
    }

    public static void putChar(Object o, long offset, char val) {
        UnsafeUtils.getInstance().putChar(o, offset, val);
    }

    public static long getLong(Object o, long offset) {
        return UnsafeUtils.getInstance().getLong(o, offset);
    }

    public static void putLong(Object o, long offset, long val) {
        UnsafeUtils.getInstance().putLong(o, offset, val);
    }

    public static float getFloat(Object o, long offset) {
        return UnsafeUtils.getInstance().getFloat(o, offset);
    }

    public static void putFloat(Object o, long offset, float val) {
        UnsafeUtils.getInstance().putFloat(o, offset, val);
    }

    public static double getDouble(Object o, long offset) {
        return UnsafeUtils.getInstance().getDouble(o, offset);
    }

    public static void putDouble(Object o, long offset, double val) {
        UnsafeUtils.getInstance().putDouble(o, offset, val);
    }

    public static long staticFieldOffset(Field field) {
        return UnsafeUtils.getInstance().staticFieldOffset(field);
    }

    public static long objectFieldOffset(Field field) {
        return UnsafeUtils.getInstance().objectFieldOffset(field);
    }

    public static Object staticFieldBase(Field field) {
        return UnsafeUtils.getInstance().staticFieldBase(field);
    }

    public static int arrayBaseOffset(Class arrayClass) {
        return UnsafeUtils.getInstance().arrayBaseOffset(arrayClass);
    }

    public static int arrayIndexScale(Class<?> arrayClass) {
        return UnsafeUtils.getInstance().arrayIndexScale(arrayClass);
    }

    public static int addressSize() {
        return UnsafeUtils.getInstance().addressSize();
    }

    public static int pageSize() {
        return UnsafeUtils.getInstance().pageSize();
    }

    public static Object getObjectVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getObjectVolatile(o, offset);
    }

    public static void putObjectVolatile(Object o, long offset, Object value) {
        UnsafeUtils.getInstance().putObjectVolatile(o, offset, value);
    }

    public static int getIntVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getIntVolatile(o, offset);
    }

    public static void putIntVolatile(Object o, long offset, int value) {
        UnsafeUtils.getInstance().putIntVolatile(o, offset, value);
    }

    public static boolean getBooleanVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getBooleanVolatile(o, offset);
    }

    public static void putBooleanVolatile(Object o, long offset, boolean value) {
        UnsafeUtils.getInstance().putBooleanVolatile(o, offset, value);
    }

    public static byte getByteVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getByteVolatile(o, offset);
    }

    public static void putByteVolatile(Object o, long offset, byte value) {
        UnsafeUtils.getInstance().putByteVolatile(o, offset, value);
    }

    public static short getShortVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getShortVolatile(o, offset);
    }

    public static void putShortVolatile(Object o, long offset, short value) {
        UnsafeUtils.getInstance().putShortVolatile(o, offset, value);
    }

    public static char getCharVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getCharVolatile(o, offset);
    }

    public static void putCharVolatile(Object o, long offset, char value) {
        UnsafeUtils.getInstance().putCharVolatile(o, offset, value);
    }

    public static long getLongVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getLongVolatile(o, offset);
    }

    public static void putLongVolatile(Object o, long offset, long value) {
        UnsafeUtils.getInstance().putLongVolatile(o, offset, value);
    }

    public static float getFloatVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getFloatVolatile(o, offset);
    }

    public static void putFloatVolatile(Object o, long offset, float value) {
        UnsafeUtils.getInstance().putFloatVolatile(o, offset, value);
    }

    public static double getDoubleVolatile(Object o, long offset) {
        return UnsafeUtils.getInstance().getDoubleVolatile(o, offset);
    }

    public static void putDoubleVolatile(Object o, long offset, double value) {
        UnsafeUtils.getInstance().putDoubleVolatile(o, offset, value);
    }

    public static void putOrderedObject(Object o, long offset, Object value) {
        UnsafeUtils.getInstance().putOrderedObject(o, offset, value);
    }

    public static void putOrderedInt(Object o, long offset, int value) {
        UnsafeUtils.getInstance().putOrderedInt(o, offset, value);
    }

    public static void putOrderedLong(Object o, long offset, long value) {
        UnsafeUtils.getInstance().putOrderedLong(o, offset, value);
    }

    public static boolean compareAndSwapObject(Object o, long offset, Object oldVal, Object newVal) {
        return UnsafeUtils.getInstance().compareAndSwapObject(o, offset, oldVal, newVal);
    }

    public static boolean compareAndSwapInt(Object o, long offset, int oldVal, int newVal) {
        return UnsafeUtils.getInstance().compareAndSwapInt(o, offset, oldVal, newVal);
    }

    public static boolean compareAndSwapLong(Object o, long offset, long oldVal, long newVal) {
        return UnsafeUtils.getInstance().compareAndSwapLong(o, offset, oldVal, newVal);
    }

    public static int getAndAddInt(Object o, long offset, int newValue) {
        return UnsafeUtils.getInstance().getAndAddInt(o, offset, newValue);
    }

    public static long getAndAddLong(Object o, long offset, long newValue) {
        return UnsafeUtils.getInstance().getAndAddLong(o, offset, newValue);
    }

    public static int getAndSetInt(Object o, long offset, int newValue) {
        return UnsafeUtils.getInstance().getAndSetInt(o, offset, newValue);
    }

    public static long getAndSetLong(Object o, long offset, long newValue) {
        return UnsafeUtils.getInstance().getAndSetLong(o, offset, newValue);
    }

    public static Object getAndSetObject(Object o, long offset, Object newValue) {
        return UnsafeUtils.getInstance().getAndSetObject(o, offset, newValue);
    }

    public static void loadFence() {
        UnsafeUtils.getInstance().loadFence();
    }

    public static void storeFence() {
        UnsafeUtils.getInstance().storeFence();
    }

    public static void fullFence() {
        UnsafeUtils.getInstance().fullFence();
    }

    public static long getAddress(Object obj) {
        Object[] array = new Object[]{obj};
        switch (ADDRESS_SIZE) {
            case 4: {
                return UnsafeUtils.getInstance().getInt(array, ARRAY_OBJECT_BASE_OFFSET);
            }
            case 8: {
                return UnsafeUtils.getInstance().getLong(array, ARRAY_OBJECT_BASE_OFFSET);
            }
        }
        throw new Error("unsupported address size: " + ADDRESS_SIZE);
    }

    public static <T> T allocateInstance(Class<T> t) throws InstantiationException {
        return (T)UnsafeUtils.getInstance().allocateInstance(t);
    }

    public static void throwException(Throwable e) {
        UnsafeUtils.getInstance().throwException(e);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field f = clazz.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            u = (Unsafe)f.get(null);
            ARRAY_BOOLEAN_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(boolean[].class);
            ARRAY_BYTE_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(byte[].class);
            ARRAY_SHORT_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(short[].class);
            ARRAY_CHAR_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(char[].class);
            ARRAY_INT_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(int[].class);
            ARRAY_LONG_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(long[].class);
            ARRAY_FLOAT_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(float[].class);
            ARRAY_DOUBLE_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(double[].class);
            ARRAY_OBJECT_BASE_OFFSET = UnsafeUtils.getInstance().arrayBaseOffset(Object[].class);
            ARRAY_BOOLEAN_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(boolean[].class);
            ARRAY_BYTE_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(byte[].class);
            ARRAY_SHORT_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(short[].class);
            ARRAY_CHAR_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(char[].class);
            ARRAY_INT_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(int[].class);
            ARRAY_LONG_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(long[].class);
            ARRAY_FLOAT_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(float[].class);
            ARRAY_DOUBLE_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(double[].class);
            ARRAY_OBJECT_INDEX_SCALE = UnsafeUtils.getInstance().arrayIndexScale(Object[].class);
            ADDRESS_SIZE = UnsafeUtils.addressSize();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        addressSize = UnsafeUtils.getInstance().addressSize();
    }
}

