package com.github.azbh111.utils.java.net;

/**
 * 子网掩码过滤器
 *
 * @author: zyp
 * @since: 2021/12/28 上午11:25
 */
public class IpMaskFilter {
    private static final int ipLen = 4;
    private final byte[] mask;
    private final byte[] target;

    public IpMaskFilter(byte[] mask, byte[] target) {
        validate(mask);
        validate(target);
        this.mask = mask;
        this.target = target;
    }

    public boolean match(byte[] ip) {
        if (ip == null || ip.length != ipLen) {
            return false;
        }
        for (int i = 0; i < ipLen; i++) {
            if ((ip[i] & mask[i]) != target[i]) {
                return false;
            }
        }
        return true;
    }

    public boolean match(String ip) {
        if (ip == null || ip.length() == 0) {
            return false;
        }
        int fromIndex = 0;
        for (int i = 0; i < ipLen; i++) {
            int dotPos = ip.indexOf('.', fromIndex);
            byte val;
            if (dotPos == -1) {
                val = NetUtils.toIpByte(Integer.parseInt(ip.substring(fromIndex)));
            } else {
                val = NetUtils.toIpByte(Integer.parseInt(ip.substring(fromIndex, dotPos)));
            }
            if ((val & mask[i]) != target[i]) {
                return false;
            }
            fromIndex = dotPos + 1;
        }
        return true;
    }

    private void validate(byte[] ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        if (ip.length != ipLen) {
            throw new RuntimeException("length of ip not equals 4");
        }
    }

    @Override
    public String toString() {
        return NetUtils.toIpString(mask) + " " + NetUtils.toIpString(target);
    }

}
