package com.github.azbh111.utils.java.predicate;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 *
 * @author pyz
 * @date 2019/2/1 9:16 PM
 */
public class PredicateUtils {

    /**
     * 返回一个用于去重用的Predicate,一个Predicate只能对一个集合使用一次(即用即产生即销毁)
     *
     * @param mappper
     * @param <T>
     * @return
     */
    public static <T, R> Predicate<T> distinctBy(Function<T, R> mappper) {
        // 用并发Set是因为返回的Predicate可能用在并发流中
        ConcurrentHashMap.KeySetView<Object, Boolean> set = ConcurrentHashMap.newKeySet();
        return item -> set.add(item);
    }

}
