/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.bit;

public class BitUtils {
    public static final byte mask_byte_0xff = (byte)-1;
    public static final short mask_short_0xffff = (short)-1;
    public static final int mask_int_0xffffffff = -1;
    public static final long mask_long_0xffffffffffffffff;
    public static final long mask_long_0x00000000ffffffff;
    public static final long mask_long_0xffffffff00000000;

    public static int ceilPowerOf2(int target) {
        if (target <= 0) {
            throw new IllegalArgumentException(String.format("\u975e\u6cd5\u8f93\u5165: %s", target));
        }
        if (BitUtils.isPowerOf2(target)) {
            return target;
        }
        int highestBit = BitUtils.indexOfHighestBit(target);
        if (highestBit == 31) {
            return Integer.MAX_VALUE;
        }
        return 1 << highestBit << 1;
    }

    public static int indexOfHighestBit(byte v) {
        if (v == 0) {
            return -1;
        }
        if (v < 0) {
            return 7;
        }
        int from = 0;
        int to = 7;
        while (from < to) {
            int mid = from + (to + 1 - from >> 1);
            if (v >>> mid > 0) {
                from = mid;
                continue;
            }
            to = mid - 1;
        }
        return from;
    }

    public static int indexOfHighestBit(short v) {
        if (v == 0) {
            return -1;
        }
        if (v < 0) {
            return 15;
        }
        int from = 0;
        int to = 15;
        while (from < to) {
            int mid = from + (to + 1 - from >> 1);
            if (v >>> mid > 0) {
                from = mid;
                continue;
            }
            to = mid - 1;
        }
        return from;
    }

    public static int indexOfHighestBit(int v) {
        if (v == 0) {
            return -1;
        }
        if (v < 0) {
            return 31;
        }
        int from = 0;
        int to = 31;
        while (from < to) {
            int mid = from + (to + 1 - from >> 1);
            if (v >>> mid > 0) {
                from = mid;
                continue;
            }
            to = mid - 1;
        }
        return from;
    }

    public static int indexOfHighestBit(long v) {
        if (v == 0L) {
            return -1;
        }
        if (v < 0L) {
            return 63;
        }
        int from = 0;
        int to = 63;
        while (from < to) {
            int mid = from + (to + 1 - from >> 1);
            if (v >>> mid > 0L) {
                from = mid;
                continue;
            }
            to = mid - 1;
        }
        return from;
    }

    public static int toInt(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return 0;
        }
        int v = 0;
        int length = Math.min(bytes.length, 4);
        for (int i = 0; i < length; ++i) {
            v |= (bytes[i] & 0xFF) << i * 8;
        }
        return v;
    }

    public static long toLong(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return 0L;
        }
        long v = 0L;
        int length = Math.min(bytes.length, 8);
        for (int i = 0; i < length; ++i) {
            v |= ((long)bytes[i] & 0xFFL) << i * 8;
        }
        return v;
    }

    public static byte[] toBytes(int v) {
        byte[] bytes = new byte[]{(byte)v, (byte)(v >>> 8), (byte)(v >>> 16), (byte)(v >>> 24)};
        return bytes;
    }

    public static byte[] toBytes(long v) {
        byte[] bytes = new byte[]{(byte)v, (byte)(v >>>= 8), (byte)(v >>>= 8), (byte)(v >>>= 8), (byte)(v >>>= 8), (byte)(v >>>= 8), (byte)(v >>>= 8), (byte)(v >>>= 8)};
        return bytes;
    }

    public static int bitsToInt(byte value) {
        return value & mask_byte_0xff;
    }

    public static int bitsToInt(short value) {
        return value & mask_short_0xffff;
    }

    public static long bitsToLong(byte value) {
        return value & mask_byte_0xff;
    }

    public static long bitsToLong(short value) {
        return value & mask_short_0xffff;
    }

    public static long bitsToLong(int value) {
        return mask_long_0x00000000ffffffff & (long)value;
    }

    public static byte reverse(byte value) {
        int i = value & 0xFF;
        i = (i & 0x5555) << 1 | i >>> 1 & 0x5555;
        i = (i & 0x3333) << 2 | i >>> 2 & 0x3333;
        i = (i & 0xF0F) << 4 | i >>> 4 & 0xF0F;
        return (byte)i;
    }

    public static short reverse(short value) {
        int i = value & 0xFFFF;
        i = (i & 0x5555) << 1 | i >>> 1 & 0x5555;
        i = (i & 0x3333) << 2 | i >>> 2 & 0x3333;
        i = (i & 0xF0F) << 4 | i >>> 4 & 0xF0F;
        i = (i & 0xFF) << 8 | i >>> 8;
        return (short)i;
    }

    public static int reverse(int value) {
        return Integer.reverse(value);
    }

    public static long reverse(long value) {
        return Long.reverse(value);
    }

    public static String toBinaryString(byte value) {
        return Integer.toBinaryString(value & 0xFF);
    }

    public static String toBinaryFullString(byte value) {
        return BitUtils.ensureLength(BitUtils.toBinaryString(value), 8);
    }

    public static String toBinaryString(short value) {
        return Integer.toBinaryString(value & 0xFFFF);
    }

    public static String toBinaryFullString(short value) {
        return BitUtils.ensureLength(BitUtils.toBinaryString(value), 16);
    }

    public static String toBinaryString(int value) {
        return Integer.toBinaryString(value);
    }

    public static String toBinaryFullString(int value) {
        return BitUtils.ensureLength(BitUtils.toBinaryString(value), 32);
    }

    public static String toBinaryString(long value) {
        return Long.toBinaryString(value);
    }

    public static String toBinaryFullString(long value) {
        return BitUtils.ensureLength(BitUtils.toBinaryString(value), 64);
    }

    public static boolean isDiffSign(int a, int b) {
        return (a ^ b) < 0;
    }

    public static int getHammingWeight(int n) {
        int m = 0;
        while (n != 0) {
            n &= n - 1;
            ++m;
        }
        return m;
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    private static String ensureLength(String str, int length) {
        if (str.length() == length) {
            return str;
        }
        int append = length - str.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < append; ++i) {
            sb.append('0');
        }
        sb.append(str);
        return sb.toString();
    }

    static {
        long v = Integer.MAX_VALUE;
        mask_long_0x00000000ffffffff = v = v << 1 | 1L;
        mask_long_0xffffffff00000000 = mask_long_0x00000000ffffffff << 32;
        mask_long_0xffffffffffffffff = mask_long_0x00000000ffffffff << 32 | mask_long_0x00000000ffffffff;
    }
}

