/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.datetime;

import com.github.azbh111.utils.java.date.DateUtils;
import com.github.azbh111.utils.java.datetime.DateTimeParseException;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class DateTimeUtils {
    public static final int HOURS_PER_DAY = 24;
    public static final int MAX_HOURS_OF_DAY = 23;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int MAX_MINUTES_OF_HOUR = 59;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int MAX_MINUTES_OF_DAY = 1439;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MAX_SECONDS_OF_MINUTE = 59;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int MAX_SECONDS_OF_HOUR = 3599;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int MAX_SECONDS_OF_DAY = 86399;
    public static final int MILLIS_PER_DAY = 86400000;
    public static final int MAX_MILLIS_OF_DAY = 86399999;
    public static final int MICROS_PER_DAY = 500654080;
    public static final int MAX_MICROS_OF_DAY = 500654079;
    public static final int NANOS_PER_SECOND = 1000000000;
    public static final int MAX_NANOS_OF_SECOND = 999999999;
    public static final long NANOS_PER_MINUTE = -129542144L;
    public static final long MAX_NANOS_OF_MINUTE = -129542145L;
    public static final long NANOS_PER_HOUR = -7772528640L;
    public static final long MAX_NANOS_OF_HOUR = -7772528641L;
    public static final long NANOS_PER_DAY = -186540687360L;
    public static final long MAX_NANOS_OF_DAY = -186540687361L;
    public static final Clock SYSTEM_DEFAULT_ZONE_CLOCK = Clock.systemDefaultZone();
    public static final Clock UTC_CLOCK = Clock.systemUTC();
    public static final ZoneId SYSTEM_DEFAULT_ZONE_ID = SYSTEM_DEFAULT_ZONE_CLOCK.getZone();
    public static final ZoneId UTC_ZONE_ID = UTC_CLOCK.getZone();
    private static final Map<String, DateTimeFormatter> formatterCache = new ConcurrentHashMap<String, DateTimeFormatter>();
    public static final DateTimeFormatter hotDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Pattern msPattern = Pattern.compile("\\d+");
    private static final Map<String, DateTimeFormatter> standardDateTimeFormatters = new LinkedHashMap<String, DateTimeFormatter>();

    public static Date toDate(LocalDate d, LocalTime t) {
        return DateTimeUtils.toDate(d.atTime(t));
    }

    public static Date toDate(LocalDateTime dt) {
        return Date.from(dt.atZone(SYSTEM_DEFAULT_ZONE_ID).toInstant());
    }

    public static long toEpochSecond() {
        return DateTimeUtils.toEpochSecond(DateTimeUtils.now());
    }

    public static long toEpochSecond(Date d) {
        return DateTimeUtils.toEpochSecond(DateTimeUtils.from(d));
    }

    public static long toEpochSecond(LocalDateTime dt) {
        return dt.atZone(SYSTEM_DEFAULT_ZONE_ID).toEpochSecond();
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime from(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), SYSTEM_DEFAULT_ZONE_ID);
    }

    public static LocalDateTime from(TemporalAccessor temporal) {
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)temporal;
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDateTime();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalDateTime();
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).atZone(SYSTEM_DEFAULT_ZONE_ID).toLocalDateTime();
        }
        try {
            int second;
            int year = temporal.get(ChronoField.YEAR);
            int month = temporal.get(ChronoField.MONTH_OF_YEAR);
            int day = temporal.get(ChronoField.DAY_OF_MONTH);
            int hour = temporal.isSupported(ChronoField.HOUR_OF_DAY) ? temporal.get(ChronoField.HOUR_OF_DAY) : 0;
            int minute = temporal.isSupported(ChronoField.MINUTE_OF_HOUR) ? temporal.get(ChronoField.MINUTE_OF_HOUR) : 0;
            int n = second = temporal.isSupported(ChronoField.SECOND_OF_MINUTE) ? temporal.get(ChronoField.SECOND_OF_MINUTE) : 0;
            int nano = temporal.isSupported(ChronoField.NANO_OF_SECOND) ? temporal.get(ChronoField.NANO_OF_SECOND) : (temporal.isSupported(ChronoField.MILLI_OF_SECOND) ? temporal.get(ChronoField.MILLI_OF_SECOND) * 1000000 : 0);
            return LocalDateTime.of(year, month, day, hour, minute, second, nano);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain LocalDateTime from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static LocalDateTime startOfDay(LocalDate d) {
        return d.atStartOfDay();
    }

    public static LocalDateTime startOfDay(Date d) {
        return DateTimeUtils.startOfDay(DateUtils.from(d));
    }

    public static LocalDateTime startOfDay() {
        return DateTimeUtils.startOfDay(DateUtils.now());
    }

    public static LocalDateTime middleOfDay() {
        return DateTimeUtils.middleOfDay(DateUtils.now());
    }

    public static LocalDateTime middleOfDay(Date d) {
        return DateTimeUtils.middleOfDay(DateUtils.from(d));
    }

    public static LocalDateTime middleOfDay(LocalDate d) {
        return d.atTime(12, 0, 0, 0);
    }

    public static LocalDateTime endOfDay() {
        return DateTimeUtils.endOfDay(DateUtils.now());
    }

    public static LocalDateTime endOfDay(Date d) {
        return DateTimeUtils.endOfDay(DateUtils.from(d));
    }

    public static LocalDateTime endOfDay(LocalDate d) {
        return d.atTime(23, 59, 59, 999999999);
    }

    public static LocalDateTime startOfWeek(Date d) {
        return DateTimeUtils.startOfWeek(DateUtils.from(d));
    }

    public static LocalDateTime startOfWeek() {
        return DateTimeUtils.startOfWeek(DateUtils.now());
    }

    public static LocalDateTime startOfWeek(LocalDate d) {
        return DateTimeUtils.startOfDay(DateUtils.firstDayOfWeek(d));
    }

    public static LocalDateTime endOfWeek(Date d) {
        return DateTimeUtils.endOfWeek(DateUtils.from(d));
    }

    public static LocalDateTime endOfWeek() {
        return DateTimeUtils.endOfWeek(DateUtils.now());
    }

    public static LocalDateTime endOfWeek(LocalDate d) {
        return DateTimeUtils.endOfDay(DateUtils.lastDayOfWeek(d));
    }

    public static LocalDateTime startOfMonth(Date d) {
        return DateTimeUtils.startOfMonth(DateUtils.from(d));
    }

    public static LocalDateTime startOfMonth() {
        return DateTimeUtils.startOfMonth(DateUtils.now());
    }

    public static LocalDateTime startOfMonth(LocalDate d) {
        return DateTimeUtils.startOfDay(DateUtils.firstDayOfWeek(d));
    }

    public static LocalDateTime endOfMonth(Date d) {
        return DateTimeUtils.endOfMonth(DateUtils.from(d));
    }

    public static LocalDateTime endOfMonth() {
        return DateTimeUtils.endOfMonth(DateUtils.now());
    }

    public static LocalDateTime endOfMonth(LocalDate d) {
        return DateTimeUtils.endOfDay(DateUtils.lastDayOfMonth(d));
    }

    public static LocalDateTime startOfYear(Date d) {
        return DateTimeUtils.startOfYear(DateUtils.from(d));
    }

    public static LocalDateTime startOfYear() {
        return DateTimeUtils.startOfYear(DateUtils.now());
    }

    public static LocalDateTime startOfYear(LocalDate d) {
        return DateTimeUtils.startOfDay(DateUtils.lastDayOfYear(d));
    }

    public static LocalDateTime endOfYear(Date d) {
        return DateTimeUtils.endOfYear(DateUtils.from(d));
    }

    public static LocalDateTime endOfYear() {
        return DateTimeUtils.endOfYear(DateUtils.now());
    }

    public static LocalDateTime endOfYear(LocalDate d) {
        return DateTimeUtils.endOfDay(DateUtils.lastDayOfYear(d));
    }

    public static String format(String format) {
        return DateTimeUtils.format(DateTimeUtils.now(), format);
    }

    public static String format(Date d, String format) {
        return DateTimeUtils.format(DateTimeUtils.from(d), format);
    }

    public static String format(TemporalAccessor t, String format) {
        DateTimeFormatter f = DateTimeUtils.getOrCreateDateTimeFormatter(format);
        return f.format(t);
    }

    public static LocalDateTime parse(String dateStr, String format) {
        DateTimeFormatter f = DateTimeUtils.getOrCreateDateTimeFormatter(format);
        return LocalDateTime.parse(dateStr, f);
    }

    public static LocalDateTime tryParse(String str) {
        if (str == null) {
            return null;
        }
        if (msPattern.matcher(str).matches()) {
            return DateTimeUtils.from(Instant.ofEpochMilli(Long.valueOf(str)));
        }
        for (DateTimeFormatter formatter : standardDateTimeFormatters.values()) {
            LocalDateTime dt;
            TemporalAccessor t = null;
            try {
                t = formatter.parse((CharSequence)str, Instant::from);
                dt = DateTimeUtils.from(t);
            }
            catch (Throwable e1) {
                try {
                    t = formatter.parse(str);
                    dt = DateTimeUtils.from(t);
                }
                catch (java.time.format.DateTimeParseException e2) {
                    continue;
                }
            }
            return dt;
        }
        throw new DateTimeParseException("Unable to parse " + str + " to LocalDateTime");
    }

    public static DateTimeFormatter getOrCreateDateTimeFormatter(String format) {
        DateTimeFormatter f = formatterCache.get(format);
        if (f == null) {
            f = DateTimeFormatter.ofPattern(format);
            formatterCache.put(format, f);
        }
        return f;
    }

    static {
        standardDateTimeFormatters.put("LOCAL_DATE_TIME", hotDateTimeFormatter);
        standardDateTimeFormatters.put("ISO_INSTANT", DateTimeFormatter.ISO_INSTANT);
        standardDateTimeFormatters.put("ISO_LOCAL_DATE_TIME", DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        standardDateTimeFormatters.put("ISO_DATE_TIME", DateTimeFormatter.ISO_DATE_TIME);
        standardDateTimeFormatters.put("ISO_OFFSET_DATE_TIME", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        standardDateTimeFormatters.put("ISO_ZONED_DATE_TIME", DateTimeFormatter.ISO_ZONED_DATE_TIME);
        standardDateTimeFormatters.put("RFC_1123_DATE_TIME", DateTimeFormatter.RFC_1123_DATE_TIME);
        standardDateTimeFormatters.putAll(DateUtils.standardDateFormatters);
    }
}

