/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.util.concurrent.atomic.AtomicBoolean;

public class RateLimit {
    private final int seconds;
    private final int limit;
    private final int timePerPermit;
    private final int fullTime;
    private AtomicBoolean lock = new AtomicBoolean(false);
    private volatile long lastAcquireTime = 0L;
    private volatile long failTimes = 0L;

    public RateLimit(int seconds, int limit) {
        if (seconds <= 0) {
            throw new RuntimeException("minute must greater than 0");
        }
        if (limit <= 0) {
            throw new RuntimeException("limit must greater than 0");
        }
        this.seconds = seconds;
        this.limit = limit;
        this.fullTime = seconds * 1000;
        this.timePerPermit = seconds * 1000 / limit;
    }

    public long tryGet() {
        return this.tryGet(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryGet(int acquire) {
        if (acquire <= 0) {
            throw new RuntimeException("acquire must greater than 0");
        }
        while (!this.lock.compareAndSet(false, true)) {
            Thread.yield();
        }
        try {
            long res;
            long time = System.currentTimeMillis();
            long lastAcquireTime = this.lastAcquireTime;
            long beginTime = time - (long)this.fullTime;
            long preAcquireTime = Math.max(lastAcquireTime, beginTime);
            long costTime = acquire * this.timePerPermit;
            long nextAcquireTime = preAcquireTime + costTime;
            if (nextAcquireTime <= time) {
                this.lastAcquireTime = nextAcquireTime;
                res = this.failTimes;
                this.failTimes = 0L;
            } else {
                ++this.failTimes;
                res = -this.failTimes;
            }
            long l = res;
            return l;
        }
        finally {
            this.lock.set(false);
        }
    }
}

