/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.properties;

import com.github.azbh111.utils.java.properties.annotation.Placeholder;
import com.github.azbh111.utils.java.resource.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.Properties;

public class PlaceholderUtils {
    public static void applyPropertiesConfig(Class clazz, Object o, String propertiesPath) throws IOException {
        InputStream is = ResourceUtils.getResourceAsStream(clazz, propertiesPath);
        if (is == null) {
            throw new NullPointerException("can not find " + propertiesPath + " in classpath.target=" + String.valueOf(o));
        }
        Properties properties = new Properties();
        properties.load(is);
        Class<?> currentClass = o.getClass();
        while (currentClass != null && currentClass != Object.class) {
            for (Field field : currentClass.getDeclaredFields()) {
                Placeholder placeholder;
                if (Modifier.isStatic(field.getModifiers()) || (placeholder = field.getAnnotation(Placeholder.class)) == null) continue;
                field.setAccessible(true);
                PlaceholderUtils.getValue(properties, placeholder, field.getType()).ifPresent(v -> {
                    try {
                        field.set(o, v);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    public static void applyStaticPropertiesConfig(Class location, Class clazz, String propertiesPath) throws IOException {
        InputStream is = ResourceUtils.getResourceAsStream(clazz, propertiesPath);
        if (is == null) {
            throw new NullPointerException("can not find " + propertiesPath + " in classpath.target=" + String.valueOf(clazz));
        }
        Properties properties = new Properties();
        properties.load(is);
        for (Field field : clazz.getDeclaredFields()) {
            Placeholder placeholder;
            if (!Modifier.isStatic(field.getModifiers()) || (placeholder = field.getAnnotation(Placeholder.class)) == null) continue;
            field.setAccessible(true);
            PlaceholderUtils.getValue(properties, placeholder, field.getType()).ifPresent(v -> {
                try {
                    field.set(null, v);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static <T> Optional<T> getValue(Properties properties, Placeholder config, Class<T> type) {
        Comparable<Byte> t;
        String value = properties.getProperty(config.value());
        if (value == null && !config.defaultValue().isEmpty()) {
            value = config.defaultValue();
        }
        if (value == null) {
            Object var4_4 = null;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            t = Byte.valueOf(value);
        } else if (type == Short.class || type == Short.TYPE) {
            t = Short.valueOf(value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            t = Integer.valueOf(value);
        } else if (type == Long.class || type == Long.TYPE) {
            t = Long.valueOf(value);
        } else if (type == Float.class || type == Float.TYPE) {
            t = Float.valueOf(value);
        } else if (type == Double.class || type == Double.TYPE) {
            t = Double.valueOf(value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            t = Boolean.valueOf(value);
        } else if (type == Character.class || type == Character.TYPE) {
            t = Character.valueOf(value.charAt(0));
        } else {
            throw new UnsupportedOperationException("unsupported type:" + String.valueOf(type));
        }
        return Optional.ofNullable(t);
    }
}

