/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

public interface DBus
extends DBusInterface {
    public static final int DBUS_NAME_FLAG_ALLOW_REPLACEMENT = 1;
    public static final int DBUS_NAME_FLAG_REPLACE_EXISTING = 2;
    public static final int DBUS_NAME_FLAG_DO_NOT_QUEUE = 4;
    public static final int DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER = 1;
    public static final int DBUS_REQUEST_NAME_REPLY_IN_QUEUE = 2;
    public static final int DBUS_REQUEST_NAME_REPLY_EXISTS = 3;
    public static final int DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER = 4;
    public static final int DBUS_RELEASE_NAME_REPLY_RELEASED = 1;
    public static final int DBUS_RELEASE_NAME_REPLY_NON_EXISTANT = 2;
    public static final int DBUS_RELEASE_NAME_REPLY_NOT_OWNER = 3;
    public static final int DBUS_START_REPLY_SUCCESS = 1;
    public static final int DBUS_START_REPLY_ALREADY_RUNNING = 2;

    public String Hello();

    public String[] ListNames();

    public boolean NameHasOwner(String var1);

    public String GetNameOwner(String var1);

    public UInt32 GetConnectionUnixUser(String var1);

    public UInt32 StartServiceByName(String var1, UInt32 var2);

    public UInt32 RequestName(String var1, UInt32 var2);

    public UInt32 ReleaseName(String var1);

    public void AddMatch(String var1) throws Error.MatchRuleInvalid;

    public void RemoveMatch(String var1) throws Error.MatchRuleInvalid;

    public String[] ListQueuedOwners(String var1);

    public UInt32 GetConnectionUnixProcessID(String var1);

    public Byte[] GetConnectionSELinuxSecurityContext(String var1);

    public void ReloadConfig();

    public static interface Binding {

        public static final class TestStruct
        extends Struct {
            @Position(value=0)
            public final String a;
            @Position(value=1)
            public final UInt32 b;
            @Position(value=2)
            public final Short c;

            public TestStruct(String a, UInt32 b, Short c) {
                this.a = a;
                this.b = b;
                this.c = c;
            }
        }

        public static final class Triplet<A, B, C>
        extends Tuple {
            @Position(value=0)
            public final A a;
            @Position(value=1)
            public final B b;
            @Position(value=2)
            public final C c;

            public Triplet(A a, B b, C c) {
                this.a = a;
                this.b = b;
                this.c = c;
            }
        }

        public static interface TestSignals
        extends DBusInterface {

            @Description(value="Sent in response to a method call")
            public static class Triggered
            extends DBusSignal {
                public final UInt64 a;

                public Triggered(String path, UInt64 a) throws DBusException {
                    super(path, a);
                    this.a = a;
                }
            }
        }

        public static interface Tests
        extends DBusInterface {
            @Description(value="Returns whatever it is passed")
            public <T> Variant<T> Identity(Variant<T> var1);

            @Description(value="Returns whatever it is passed")
            public byte IdentityByte(byte var1);

            @Description(value="Returns whatever it is passed")
            public boolean IdentityBool(boolean var1);

            @Description(value="Returns whatever it is passed")
            public short IdentityInt16(short var1);

            @Description(value="Returns whatever it is passed")
            public UInt16 IdentityUInt16(UInt16 var1);

            @Description(value="Returns whatever it is passed")
            public int IdentityInt32(int var1);

            @Description(value="Returns whatever it is passed")
            public UInt32 IdentityUInt32(UInt32 var1);

            @Description(value="Returns whatever it is passed")
            public long IdentityInt64(long var1);

            @Description(value="Returns whatever it is passed")
            public UInt64 IdentityUInt64(UInt64 var1);

            @Description(value="Returns whatever it is passed")
            public double IdentityDouble(double var1);

            @Description(value="Returns whatever it is passed")
            public String IdentityString(String var1);

            @Description(value="Returns whatever it is passed")
            public <T> Variant<T>[] IdentityArray(Variant<T>[] var1);

            @Description(value="Returns whatever it is passed")
            public byte[] IdentityByteArray(byte[] var1);

            @Description(value="Returns whatever it is passed")
            public boolean[] IdentityBoolArray(boolean[] var1);

            @Description(value="Returns whatever it is passed")
            public short[] IdentityInt16Array(short[] var1);

            @Description(value="Returns whatever it is passed")
            public UInt16[] IdentityUInt16Array(UInt16[] var1);

            @Description(value="Returns whatever it is passed")
            public int[] IdentityInt32Array(int[] var1);

            @Description(value="Returns whatever it is passed")
            public UInt32[] IdentityUInt32Array(UInt32[] var1);

            @Description(value="Returns whatever it is passed")
            public long[] IdentityInt64Array(long[] var1);

            @Description(value="Returns whatever it is passed")
            public UInt64[] IdentityUInt64Array(UInt64[] var1);

            @Description(value="Returns whatever it is passed")
            public double[] IdentityDoubleArray(double[] var1);

            @Description(value="Returns whatever it is passed")
            public String[] IdentityStringArray(String[] var1);

            @Description(value="Returns the sum of the values in the input list")
            public long Sum(int[] var1);

            @Description(value="Given a map of A => B, should return a map of B => a list of all the As which mapped to B")
            public Map<String, List<String>> InvertMapping(Map<String, String> var1);

            @Description(value="This method returns the contents of a struct as separate values")
            public Triplet<String, UInt32, Short> DeStruct(TestStruct var1);

            @Description(value="Given any compound type as a variant, return all the primitive types recursively contained within as an array of variants")
            public List<Variant<Object>> Primitize(Variant<Object> var1);

            @Description(value="inverts it's input")
            public boolean Invert(boolean var1);

            @Description(value="triggers sending of a signal from the supplied object with the given parameter")
            public void Trigger(String var1, UInt64 var2);

            @Description(value="Causes the server to exit")
            public void Exit();
        }

        public static interface TestClient
        extends DBusInterface {
            @Description(value="when the trigger signal is received, this method should be called on the sending process/object.")
            public void Response(UInt16 var1, double var2);

            @Description(value="Causes a callback")
            public static class Trigger
            extends DBusSignal {
                public final UInt16 a;
                public final double b;

                public Trigger(String path, UInt16 a, double b) throws DBusException {
                    super(path, a, b);
                    this.a = a;
                    this.b = b;
                }
            }
        }

        public static interface SingleTests
        extends DBusInterface {
            @Description(value="Returns the sum of the values in the input list")
            public UInt32 Sum(byte[] var1);
        }
    }

    public static interface GLib {

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface CSymbol {
            public String value();
        }
    }

    public static interface Method {

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Error {
            public String value();
        }

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface NoReply {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Deprecated {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Description {
        public String value();
    }

    public static interface Error {

        public static class AccessDenied
        extends DBusExecutionException {
            public AccessDenied(String message) {
                super(message);
            }
        }

        public static class NoReply
        extends DBusExecutionException {
            public NoReply(String message) {
                super(message);
            }
        }

        public static class MatchRuleInvalid
        extends DBusExecutionException {
            public MatchRuleInvalid(String message) {
                super(message);
            }
        }

        public static class ServiceUnknown
        extends DBusExecutionException {
            public ServiceUnknown(String message) {
                super(message);
            }
        }

        public static class UnknownObject
        extends DBusExecutionException {
            public UnknownObject(String message) {
                super(message);
            }
        }

        public static class UnknownMethod
        extends DBusExecutionException {
            public UnknownMethod(String message) {
                super(message);
            }
        }
    }

    public static class NameAcquired
    extends DBusSignal {
        public final String name;

        public NameAcquired(String path, String name) throws DBusException {
            super(path, name);
            this.name = name;
        }
    }

    public static class NameLost
    extends DBusSignal {
        public final String name;

        public NameLost(String path, String name) throws DBusException {
            super(path, name);
            this.name = name;
        }
    }

    public static class NameOwnerChanged
    extends DBusSignal {
        public final String name;
        public final String old_owner;
        public final String new_owner;

        public NameOwnerChanged(String path, String name, String old_owner, String new_owner) throws DBusException {
            super(path, name, old_owner, new_owner);
            this.name = name;
            this.old_owner = old_owner;
            this.new_owner = new_owner;
        }
    }

    public static interface Local
    extends DBusInterface {

        public static class Disconnected
        extends DBusSignal {
            public Disconnected(String path) throws DBusException {
                super(path, new Object[0]);
            }
        }
    }

    public static interface Properties
    extends DBusInterface {
        public <A> A Get(String var1, String var2);

        public <A> void Set(String var1, String var2, A var3);

        public Map<String, Variant> GetAll(String var1);
    }

    public static interface Introspectable
    extends DBusInterface {
        public String Introspect();
    }

    public static interface Peer
    extends DBusInterface {
        public void Ping();
    }
}

