/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;

class RemoteInvocationHandler
implements InvocationHandler {
    public static final int CALL_TYPE_SYNC = 0;
    public static final int CALL_TYPE_ASYNC = 1;
    public static final int CALL_TYPE_CALLBACK = 2;
    AbstractConnection conn;
    RemoteObject remote;

    public static Object convertRV(String sig, Object[] rp, Method m, AbstractConnection conn) throws DBusException {
        Class<?> c = m.getReturnType();
        if (null == rp) {
            if (null == c || Void.TYPE.equals(c)) {
                return null;
            }
            throw new DBusExecutionException(Gettext._("Wrong return type (got void, expected a value)"));
        }
        try {
            rp = Marshalling.deSerializeParameters(rp, new Type[]{m.getGenericReturnType()}, conn);
        }
        catch (Exception e) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(MessageFormat.format(Gettext._("Wrong return type (failed to de-serialize correct types: {0} )"), e.getMessage()));
        }
        switch (rp.length) {
            case 0: {
                if (null == c || Void.TYPE.equals(c)) {
                    return null;
                }
                throw new DBusExecutionException(Gettext._("Wrong return type (got void, expected a value)"));
            }
            case 1: {
                return rp[0];
            }
        }
        if (!Tuple.class.isAssignableFrom(c)) {
            throw new DBusExecutionException(Gettext._("Wrong return type (not expecting Tuple)"));
        }
        Constructor<?> cons = c.getConstructors()[0];
        try {
            return cons.newInstance(rp);
        }
        catch (Exception e) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeRemoteMethod(RemoteObject ro, Method m, AbstractConnection conn, int syncmethod, CallbackHandler callback, Object ... args) throws DBusExecutionException {
        MethodCall call;
        Type[] ts = m.getGenericParameterTypes();
        String sig = null;
        if (ts.length > 0) {
            try {
                sig = Marshalling.getDBusType(ts);
                args = Marshalling.convertParameters(args, ts, conn);
            }
            catch (DBusException DBe) {
                throw new DBusExecutionException(Gettext._("Failed to construct D-Bus type: ") + DBe.getMessage());
            }
        }
        byte flags = 0;
        if (!ro.autostart) {
            flags = (byte)(flags | 2);
        }
        if (syncmethod == 1) {
            flags = (byte)(flags | 0x40);
        }
        if (m.isAnnotationPresent(DBus.Method.NoReply.class)) {
            flags = (byte)(flags | 1);
        }
        try {
            String name = m.isAnnotationPresent(DBusMemberName.class) ? m.getAnnotation(DBusMemberName.class).value() : m.getName();
            call = null == ro.iface ? new MethodCall(ro.busname, ro.objectpath, null, name, flags, sig, args) : (null != ro.iface.getAnnotation(DBusInterfaceName.class) ? new MethodCall(ro.busname, ro.objectpath, ro.iface.getAnnotation(DBusInterfaceName.class).value(), name, flags, sig, args) : new MethodCall(ro.busname, ro.objectpath, AbstractConnection.dollar_pattern.matcher(ro.iface.getName()).replaceAll("."), name, flags, sig, args));
        }
        catch (DBusException DBe) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(Gettext._("Failed to construct outgoing method call: ") + DBe.getMessage());
        }
        if (null == conn.outgoing) {
            throw new NotConnected(Gettext._("Not Connected"));
        }
        switch (syncmethod) {
            case 1: {
                conn.queueOutgoing(call);
                return new DBusAsyncReply(call, m, conn);
            }
            case 2: {
                Map<MethodCall, CallbackHandler<? extends Object>> DBe = conn.pendingCallbacks;
                synchronized (DBe) {
                    conn.pendingCallbacks.put(call, callback);
                    conn.pendingCallbackReplys.put(call, new DBusAsyncReply(call, m, conn));
                }
                conn.queueOutgoing(call);
                return null;
            }
            case 0: {
                conn.queueOutgoing(call);
            }
        }
        if (m.isAnnotationPresent(DBus.Method.NoReply.class)) {
            return null;
        }
        Message reply = call.getReply();
        if (null == reply) {
            throw new DBus.Error.NoReply(Gettext._("No reply within specified time"));
        }
        if (reply instanceof Error) {
            ((Error)reply).throwException();
        }
        try {
            return RemoteInvocationHandler.convertRV(reply.getSig(), reply.getParameters(), m, conn);
        }
        catch (DBusException e) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public RemoteInvocationHandler(AbstractConnection conn, RemoteObject remote) {
        this.remote = remote;
        this.conn = conn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block20: {
            if (method.getName().equals("isRemote")) {
                return true;
            }
            if (method.getName().equals("clone")) {
                return null;
            }
            if (method.getName().equals("equals")) {
                try {
                    if (1 == args.length) {
                        return new Boolean(this.remote.equals(((RemoteInvocationHandler)Proxy.getInvocationHandler((Object)args[0])).remote));
                    }
                    break block20;
                }
                catch (IllegalArgumentException IAe) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("finalize")) {
                return null;
            }
            if (method.getName().equals("getClass")) {
                return DBusInterface.class;
            }
            if (method.getName().equals("hashCode")) {
                return this.remote.hashCode();
            }
            if (method.getName().equals("notify")) {
                this.remote.notify();
                return null;
            }
            if (method.getName().equals("notifyAll")) {
                this.remote.notifyAll();
                return null;
            }
            if (method.getName().equals("wait")) {
                if (0 == args.length) {
                    this.remote.wait();
                } else if (1 == args.length && args[0] instanceof Long) {
                    this.remote.wait((Long)args[0]);
                } else if (2 == args.length && args[0] instanceof Long && args[1] instanceof Integer) {
                    this.remote.wait((Long)args[0], (Integer)args[1]);
                }
                if (args.length <= 2) {
                    return null;
                }
            } else if (method.getName().equals("toString")) {
                return this.remote.toString();
            }
        }
        return RemoteInvocationHandler.executeRemoteMethod(this.remote, method, this.conn, 0, null, args);
    }
}

