/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import cx.ath.matthew.unix.UnixServerSocket;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.DirectConnection;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalException;

public class DBusDaemon
extends Thread {
    public static final int QUEUE_POLL_WAIT = 500;
    private Map<Connstruct, Reader> conns = new HashMap<Connstruct, Reader>();
    private HashMap<String, Connstruct> names = new HashMap();
    private MagicMap<Message, WeakReference<Connstruct>> outqueue = new MagicMap("out");
    private MagicMap<Message, WeakReference<Connstruct>> inqueue = new MagicMap("in");
    private MagicMap<Message, WeakReference<Connstruct>> localqueue = new MagicMap("local");
    private List<Connstruct> sigrecips = new Vector<Connstruct>();
    private boolean _run = true;
    private int next_unique = 0;
    private Object unique_lock = new Object();
    DBusServer dbus_server = new DBusServer();
    Sender sender = new Sender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusDaemon() {
        this.setName("Daemon");
        HashMap<String, Connstruct> hashMap = this.names;
        synchronized (hashMap) {
            this.names.put("org.freedesktop.DBus", null);
        }
    }

    private void send(Connstruct c, Message m) {
        this.send(c, m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Connstruct c, Message m, boolean head) {
        if (null == c) {
            Map<Connstruct, Reader> map = this.conns;
            synchronized (map) {
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
                synchronized (magicMap) {
                    for (Connstruct d : this.conns.keySet()) {
                        if (head) {
                            this.outqueue.putFirst(m, new WeakReference<Connstruct>(d));
                            continue;
                        }
                        this.outqueue.putLast(m, new WeakReference<Connstruct>(d));
                    }
                    this.outqueue.notifyAll();
                }
            }
        }
        MagicMap<Message, WeakReference<Connstruct>> magicMap = this.outqueue;
        synchronized (magicMap) {
            if (head) {
                this.outqueue.putFirst(m, new WeakReference<Connstruct>(c));
            } else {
                this.outqueue.putLast(m, new WeakReference<Connstruct>(c));
            }
            this.outqueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connstruct> findSignalMatches(DBusSignal sig) {
        Vector<Connstruct> l;
        List<Connstruct> list = this.sigrecips;
        synchronized (list) {
            l = new Vector<Connstruct>(this.sigrecips);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this._run) {
            try {
                List<WeakReference<Connstruct>> wcs;
                Message m;
                MagicMap<Message, WeakReference<Connstruct>> magicMap = this.inqueue;
                synchronized (magicMap) {
                    while (0 == this.inqueue.size()) {
                        try {
                            this.inqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    m = this.inqueue.head();
                    wcs = this.inqueue.remove(m);
                }
                if (null == wcs) continue;
                for (WeakReference weakReference : wcs) {
                    Connstruct c = (Connstruct)weakReference.get();
                    if (null == c) continue;
                    if (!(null != c.unique || m instanceof MethodCall && "org.freedesktop.DBus".equals(m.getDestination()) && "Hello".equals(m.getName()))) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.AccessDenied", m.getSerial(), "s", Gettext._("You must send a Hello message")));
                        continue;
                    }
                    try {
                        if (null != c.unique) {
                            m.setSource(c.unique);
                        }
                    }
                    catch (DBusException DBe) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.GeneralError", m.getSerial(), "s", Gettext._("Sending message failed")));
                    }
                    if ("org.freedesktop.DBus".equals(m.getDestination())) {
                        MagicMap<Message, WeakReference<Connstruct>> DBe = this.localqueue;
                        synchronized (DBe) {
                            this.localqueue.putLast(m, weakReference);
                            this.localqueue.notifyAll();
                            continue;
                        }
                    }
                    if (m instanceof DBusSignal) {
                        List<Connstruct> list = this.findSignalMatches((DBusSignal)m);
                        for (Connstruct d : list) {
                            this.send(d, m);
                        }
                        continue;
                    }
                    Connstruct dest = this.names.get(m.getDestination());
                    if (null == dest) {
                        this.send(c, new Error("org.freedesktop.DBus", null, "org.freedesktop.DBus.Error.ServiceUnknown", m.getSerial(), "s", MessageFormat.format(Gettext._("The name `{0}' does not exist"), m.getDestination())));
                        continue;
                    }
                    this.send(dest, m);
                }
            }
            catch (DBusException dBusException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connstruct c) {
        boolean exists;
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            exists = this.conns.containsKey(c);
            if (exists) {
                Reader r = this.conns.get(c);
                r.stopRunning();
                this.conns.remove(c);
            }
        }
        if (exists) {
            try {
                if (null != c.usock) {
                    c.usock.close();
                }
                if (null != c.tsock) {
                    c.tsock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            map = this.names;
            synchronized (map) {
                Vector<String> toRemove = new Vector<String>();
                for (String name : this.names.keySet()) {
                    if (this.names.get(name) != c) continue;
                    toRemove.add(name);
                    try {
                        this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, c.unique, ""));
                    }
                    catch (DBusException dBusException) {}
                }
                for (String name : toRemove) {
                    this.names.remove(name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(UnixSocket us) {
        Connstruct c = new Connstruct(us);
        Reader r = new Reader(c);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(c, r);
        }
        r.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSock(Socket s) throws IOException {
        Connstruct c = new Connstruct(s);
        Reader r = new Reader(c);
        Map<Connstruct, Reader> map = this.conns;
        synchronized (map) {
            this.conns.put(c, r);
        }
        r.start();
    }

    public static void syntax() {
        System.out.println("Syntax: DBusDaemon [--version] [-v] [--help] [-h] [--listen address] [-l address] [--print-address] [-r] [--pidfile file] [-p file] [--addressfile file] [-a file] [--unix] [-u] [--tcp] [-t] ");
        System.exit(1);
    }

    public static void version() {
        System.out.println("D-Bus Java Version: " + System.getProperty("Version"));
        System.exit(1);
    }

    public static void saveFile(String data, String file) throws IOException {
        PrintWriter w = new PrintWriter(new FileOutputStream(file));
        w.println(data);
        w.close();
    }

    public static void main(String[] args) throws Exception {
        String addr = null;
        String pidfile = null;
        String addrfile = null;
        boolean printaddress = false;
        boolean unix = true;
        boolean tcp = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                    DBusDaemon.syntax();
                    continue;
                }
                if ("--version".equals(args[i]) || "-v".equals(args[i])) {
                    DBusDaemon.version();
                    continue;
                }
                if ("--listen".equals(args[i]) || "-l".equals(args[i])) {
                    addr = args[++i];
                    continue;
                }
                if ("--pidfile".equals(args[i]) || "-p".equals(args[i])) {
                    pidfile = args[++i];
                    continue;
                }
                if ("--addressfile".equals(args[i]) || "-a".equals(args[i])) {
                    addrfile = args[++i];
                    continue;
                }
                if ("--print-address".equals(args[i]) || "-r".equals(args[i])) {
                    printaddress = true;
                    continue;
                }
                if ("--unix".equals(args[i]) || "-u".equals(args[i])) {
                    unix = true;
                    tcp = false;
                    continue;
                }
                if ("--tcp".equals(args[i]) || "-t".equals(args[i])) {
                    tcp = true;
                    unix = false;
                    continue;
                }
                DBusDaemon.syntax();
            }
        }
        catch (ArrayIndexOutOfBoundsException AIOOBe) {
            DBusDaemon.syntax();
        }
        if (null == addr && unix) {
            addr = DirectConnection.createDynamicSession();
        } else if (null == addr && tcp) {
            addr = DirectConnection.createDynamicTCPSession();
        }
        BusAddress address = new BusAddress(addr);
        if (null == address.getParameter("guid")) {
            addr = addr + ",guid=" + Transport.genGUID();
            address = new BusAddress(addr);
        }
        if (printaddress) {
            System.out.println(addr);
        }
        if (null != addrfile) {
            DBusDaemon.saveFile(addr, addrfile);
        }
        if (null != pidfile) {
            DBusDaemon.saveFile(System.getProperty("Pid"), pidfile);
        }
        if ("unix".equals(address.getType())) {
            DBusDaemon.doUnix(address);
        } else if ("tcp".equals(address.getType())) {
            DBusDaemon.doTCP(address);
        } else {
            throw new Exception("Unknown address type: " + address.getType());
        }
    }

    private static void doUnix(BusAddress address) throws IOException {
        UnixServerSocket uss = null != address.getParameter("abstract") ? new UnixServerSocket(new UnixSocketAddress(address.getParameter("abstract"), true)) : new UnixServerSocket(new UnixSocketAddress(address.getParameter("path"), false));
        DBusDaemon d = new DBusDaemon();
        d.start();
        d.sender.start();
        d.dbus_server.start();
        while (d._run) {
            UnixSocket s = uss.accept();
            if (new Transport.SASL().auth(1, 1, address.getParameter("guid"), s.getOutputStream(), s.getInputStream(), s)) {
                d.addSock(s);
                continue;
            }
            s.close();
        }
    }

    private static void doTCP(BusAddress address) throws IOException {
        ServerSocket ss = new ServerSocket(Integer.parseInt(address.getParameter("port")), 10, InetAddress.getByName(address.getParameter("host")));
        DBusDaemon d = new DBusDaemon();
        d.start();
        d.sender.start();
        d.dbus_server.start();
        while (d._run) {
            Socket s = ss.accept();
            boolean authOK = false;
            try {
                authOK = new Transport.SASL().auth(1, 1, address.getParameter("guid"), s.getOutputStream(), s.getInputStream(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (authOK) {
                d.addSock(s);
                continue;
            }
            s.close();
        }
    }

    public class Reader
    extends Thread {
        private Connstruct conn;
        private WeakReference<Connstruct> weakconn;
        private boolean _lrun = true;

        public Reader(Connstruct conn) {
            this.conn = conn;
            this.weakconn = new WeakReference<Connstruct>(conn);
            this.setName("Reader");
        }

        public void stopRunning() {
            this._lrun = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this._run && this._lrun) {
                Message m;
                block7: {
                    m = null;
                    try {
                        m = this.conn.min.readMessage();
                    }
                    catch (IOException IOe) {
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                    catch (DBusException DBe) {
                        if (!(DBe instanceof FatalException)) break block7;
                        DBusDaemon.this.removeConnection(this.conn);
                    }
                }
                if (null == m) continue;
                MagicMap magicMap = DBusDaemon.this.inqueue;
                synchronized (magicMap) {
                    DBusDaemon.this.inqueue.putLast(m, this.weakconn);
                    DBusDaemon.this.inqueue.notifyAll();
                }
            }
            this.conn = null;
        }
    }

    public class Sender
    extends Thread {
        public Sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this._run) {
                Message m = null;
                List wcs = null;
                MagicMap magicMap = DBusDaemon.this.outqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.outqueue.size() == 0) {
                        try {
                            DBusDaemon.this.outqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    m = (Message)DBusDaemon.this.outqueue.head();
                    wcs = DBusDaemon.this.outqueue.remove(m);
                }
                if (null == wcs) continue;
                for (WeakReference wc : wcs) {
                    Connstruct c = (Connstruct)wc.get();
                    if (null == c) continue;
                    try {
                        c.mout.writeMessage(m);
                    }
                    catch (IOException IOe) {
                        DBusDaemon.this.removeConnection(c);
                    }
                }
            }
        }
    }

    public class DBusServer
    extends Thread
    implements DBus,
    DBus.Introspectable,
    DBus.Peer {
        public Connstruct c;
        public Message m;

        public DBusServer() {
            this.setName("Server");
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String Hello() {
            Object object = this.c;
            synchronized (object) {
                if (null != this.c.unique) {
                    throw new DBus.Error.AccessDenied(Gettext._("Connection has already sent a Hello message"));
                }
                Object object2 = DBusDaemon.this.unique_lock;
                synchronized (object2) {
                    this.c.unique = ":1." + ++DBusDaemon.this.next_unique;
                }
            }
            object = DBusDaemon.this.names;
            synchronized (object) {
                DBusDaemon.this.names.put(this.c.unique, this.c);
            }
            try {
                DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", this.c.unique));
                DBusSignal s = new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", this.c.unique, "", this.c.unique);
                DBusDaemon.this.send(null, s);
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
            return this.c.unique;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] ListNames() {
            String[] ns;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                Set nss = DBusDaemon.this.names.keySet();
                ns = nss.toArray(new String[0]);
            }
            return ns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean NameHasOwner(String name) {
            boolean rv;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                rv = DBusDaemon.this.names.containsKey(name);
            }
            return rv;
        }

        @Override
        public String GetNameOwner(String name) {
            Connstruct owner = (Connstruct)DBusDaemon.this.names.get(name);
            String o = null == owner ? "" : owner.unique;
            return o;
        }

        @Override
        public UInt32 GetConnectionUnixUser(String connection_name) {
            return new UInt32(0L);
        }

        @Override
        public UInt32 StartServiceByName(String name, UInt32 flags) {
            return new UInt32(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 RequestName(String name, UInt32 flags) {
            int rv;
            boolean exists = false;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                exists = DBusDaemon.this.names.containsKey(name);
                if (!exists) {
                    DBusDaemon.this.names.put(name, this.c);
                }
            }
            if (exists) {
                rv = 3;
            } else {
                rv = 1;
                try {
                    DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameAcquired", "s", name));
                    DBusDaemon.this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, "", this.c.unique));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            }
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UInt32 ReleaseName(String name) {
            int rv;
            boolean exists = false;
            HashMap hashMap = DBusDaemon.this.names;
            synchronized (hashMap) {
                exists = DBusDaemon.this.names.containsKey(name) && ((Connstruct)DBusDaemon.this.names.get(name)).equals(this.c);
                if (exists) {
                    DBusDaemon.this.names.remove(name);
                }
            }
            if (!exists) {
                rv = 2;
            } else {
                rv = 1;
                try {
                    DBusDaemon.this.send(this.c, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameLost", "s", name));
                    DBusDaemon.this.send(null, new DBusSignal("org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameOwnerChanged", "sss", name, this.c.unique, ""));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            }
            return new UInt32(rv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddMatch(String matchrule) throws DBus.Error.MatchRuleInvalid {
            List list = DBusDaemon.this.sigrecips;
            synchronized (list) {
                if (!DBusDaemon.this.sigrecips.contains(this.c)) {
                    DBusDaemon.this.sigrecips.add(this.c);
                }
            }
        }

        @Override
        public void RemoveMatch(String matchrule) throws DBus.Error.MatchRuleInvalid {
        }

        @Override
        public String[] ListQueuedOwners(String name) {
            return new String[0];
        }

        @Override
        public UInt32 GetConnectionUnixProcessID(String connection_name) {
            return new UInt32(0L);
        }

        @Override
        public Byte[] GetConnectionSELinuxSecurityContext(String a) {
            return new Byte[0];
        }

        @Override
        public void ReloadConfig() {
        }

        private void handleMessage(Connstruct c, Message m) throws DBusException {
            block9: {
                if (!(m instanceof MethodCall)) {
                    return;
                }
                Object[] args = m.getParameters();
                Class[] cs = new Class[args.length];
                for (int i = 0; i < cs.length; ++i) {
                    cs[i] = args[i].getClass();
                }
                Method meth = null;
                Object rv = null;
                try {
                    meth = DBusServer.class.getMethod(m.getName(), cs);
                    try {
                        this.c = c;
                        this.m = m;
                        rv = meth.invoke((Object)DBusDaemon.this.dbus_server, args);
                        if (null == rv) {
                            DBusDaemon.this.send(c, new MethodReturn("org.freedesktop.DBus", (MethodCall)m, null, new Object[0]), true);
                            break block9;
                        }
                        String sig = Marshalling.getDBusType(meth.getGenericReturnType())[0];
                        DBusDaemon.this.send(c, new MethodReturn("org.freedesktop.DBus", (MethodCall)m, sig, rv), true);
                    }
                    catch (InvocationTargetException ITe) {
                        DBusDaemon.this.send(c, new Error("org.freedesktop.DBus", m, ITe.getCause()));
                    }
                    catch (DBusExecutionException DBEe) {
                        DBusDaemon.this.send(c, new Error("org.freedesktop.DBus", m, DBEe));
                    }
                    catch (Exception e) {
                        DBusDaemon.this.send(c, new Error("org.freedesktop.DBus", c.unique, "org.freedesktop.DBus.Error.GeneralError", m.getSerial(), "s", Gettext._("An error occurred while calling ") + m.getName()));
                    }
                }
                catch (NoSuchMethodException NSMe) {
                    DBusDaemon.this.send(c, new Error("org.freedesktop.DBus", c.unique, "org.freedesktop.DBus.Error.UnknownMethod", m.getSerial(), "s", Gettext._("This service does not support ") + m.getName()));
                }
            }
        }

        @Override
        public String Introspect() {
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n<node>\n  <interface name=\"org.freedesktop.DBus.Introspectable\">\n    <method name=\"Introspect\">\n      <arg name=\"data\" direction=\"out\" type=\"s\"/>\n    </method>\n  </interface>\n  <interface name=\"org.freedesktop.DBus\">\n    <method name=\"RequestName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"ReleaseName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"StartServiceByName\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"in\" type=\"u\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"Hello\">\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"NameHasOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"b\"/>\n    </method>\n    <method name=\"ListNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"ListActivatableNames\">\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"AddMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"RemoveMatch\">\n      <arg direction=\"in\" type=\"s\"/>\n    </method>\n    <method name=\"GetNameOwner\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"s\"/>\n    </method>\n    <method name=\"ListQueuedOwners\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"as\"/>\n    </method>\n    <method name=\"GetConnectionUnixUser\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionUnixProcessID\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"u\"/>\n    </method>\n    <method name=\"GetConnectionSELinuxSecurityContext\">\n      <arg direction=\"in\" type=\"s\"/>\n      <arg direction=\"out\" type=\"ay\"/>\n    </method>\n    <method name=\"ReloadConfig\">\n    </method>\n    <signal name=\"NameOwnerChanged\">\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameLost\">\n      <arg type=\"s\"/>\n    </signal>\n    <signal name=\"NameAcquired\">\n      <arg type=\"s\"/>\n    </signal>\n  </interface>\n</node>";
        }

        @Override
        public void Ping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DBusDaemon.this._run) {
                List wcs;
                Message m;
                MagicMap magicMap = DBusDaemon.this.localqueue;
                synchronized (magicMap) {
                    while (DBusDaemon.this.localqueue.size() == 0) {
                        try {
                            DBusDaemon.this.localqueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    m = (Message)DBusDaemon.this.localqueue.head();
                    wcs = DBusDaemon.this.localqueue.remove(m);
                }
                if (null == wcs) continue;
                try {
                    for (WeakReference wc : wcs) {
                        Connstruct c = (Connstruct)wc.get();
                        if (null == c) continue;
                        this.handleMessage(c, m);
                    }
                }
                catch (DBusException dBusException) {
                }
            }
        }
    }

    static class MagicMap<A, B> {
        private Map<A, LinkedList<B>> m = new HashMap<A, LinkedList<B>>();
        private LinkedList<A> q = new LinkedList();
        private String name;

        public MagicMap(String name) {
            this.name = name;
        }

        public A head() {
            return this.q.getFirst();
        }

        public void putFirst(A a, B b) {
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(b);
                this.m.put(a, l);
            }
            this.q.addFirst(a);
        }

        public void putLast(A a, B b) {
            if (this.m.containsKey(a)) {
                this.m.get(a).add(b);
            } else {
                LinkedList<B> l = new LinkedList<B>();
                l.add(b);
                this.m.put(a, l);
            }
            this.q.addLast(a);
        }

        public List<B> remove(A a) {
            this.q.remove(a);
            return this.m.remove(a);
        }

        public int size() {
            return this.q.size();
        }
    }

    static class Connstruct {
        public UnixSocket usock;
        public Socket tsock;
        public MessageReader min;
        public MessageWriter mout;
        public String unique;

        public Connstruct(UnixSocket sock) {
            this.usock = sock;
            this.min = new MessageReader(sock.getInputStream());
            this.mout = new MessageWriter(sock.getOutputStream());
        }

        public Connstruct(Socket sock) throws IOException {
            this.tsock = sock;
            this.min = new MessageReader(sock.getInputStream());
            this.mout = new MessageWriter(sock.getOutputStream());
        }

        public String toString() {
            return null == this.unique ? ":?-?" : this.unique;
        }
    }
}

