/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import com.diogonunes.jcdp.color.ColoredPrinter;
import com.diogonunes.jcdp.color.api.Ansi;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Objects;
import java.util.StringTokenizer;

public class ColorWriter
extends Writer {
    public static final String GRAY = "\u00a7%";
    public static final String YELLOW = "\u00a7!";
    public static final String WHITE = "\u00a7+";
    public static final String GREEN = "\u00a7'";
    public static final String CYAN = "\u00a7$";
    public static final String MAGENTA = "\u00a7~";
    public static final String OK_COLOR = "\u00a7=";
    public static final String FAIL_COLOR = "\u00a7\u00f7";
    protected final ColoredPrinter coloredPrinter;
    protected final PrintStream printStream;

    public ColorWriter() {
        this.coloredPrinter = new ColoredPrinter.Builder(1, false).build();
        this.printStream = null;
    }

    public ColorWriter(PrintStream stream) {
        this.coloredPrinter = null;
        this.printStream = Objects.requireNonNull(stream);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        String txt = new String(cbuf, off, len);
        txt = txt.replace('\u00a0', ' ');
        if (this.coloredPrinter != null) {
            StringTokenizer st = new StringTokenizer(txt, "\u00a7", true);
            boolean wasDelimiter = false;
            Ansi.FColor fc = Ansi.FColor.WHITE;
            Ansi.BColor bg = Ansi.BColor.NONE;
            Ansi.Attribute attr = Ansi.Attribute.NONE;
            block20: while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 0 && wasDelimiter) {
                    wasDelimiter = false;
                    char type = token.charAt(0);
                    if ((token = token.substring(1)).isEmpty()) continue;
                    switch (type) {
                        case '+': {
                            fc = Ansi.FColor.WHITE;
                            attr = Ansi.Attribute.LIGHT;
                            break;
                        }
                        case '!': {
                            fc = Ansi.FColor.YELLOW;
                            attr = Ansi.Attribute.LIGHT;
                            break;
                        }
                        case '\'': {
                            fc = Ansi.FColor.GREEN;
                            attr = Ansi.Attribute.LIGHT;
                            break;
                        }
                        case '%': {
                            fc = Ansi.FColor.WHITE;
                            bg = Ansi.BColor.NONE;
                            attr = Ansi.Attribute.CLEAR;
                            break;
                        }
                        case '$': {
                            fc = Ansi.FColor.CYAN;
                            attr = Ansi.Attribute.LIGHT;
                            break;
                        }
                        case '~': {
                            fc = Ansi.FColor.MAGENTA;
                            attr = Ansi.Attribute.LIGHT;
                            break;
                        }
                        case '=': {
                            bg = Ansi.BColor.GREEN;
                            break;
                        }
                        case '\u00f7': {
                            bg = Ansi.BColor.RED;
                            break;
                        }
                        default: {
                            this.coloredPrinter.print((Object)("\u00a7" + token));
                            continue block20;
                        }
                    }
                    this.coloredPrinter.print((Object)token, attr, fc, bg);
                    continue;
                }
                if ("\u00a7".equals(token)) {
                    wasDelimiter = true;
                    continue;
                }
                wasDelimiter = false;
                this.coloredPrinter.print((Object)token);
            }
            if (txt.indexOf(167) > -1) {
                this.coloredPrinter.clear();
            }
        } else {
            StringTokenizer st = new StringTokenizer(txt, "\u00a7", true);
            boolean wasDelimiter = false;
            String prefix = null;
            block21: while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 1 && wasDelimiter) {
                    wasDelimiter = false;
                    char type = token.charAt(0);
                    token = token.substring(1);
                    switch (type) {
                        case '+': {
                            prefix = "\u001b[37m\u001b[1m";
                            break;
                        }
                        case '!': {
                            prefix = "\u001b[33m\u001b[1m";
                            break;
                        }
                        case '\'': {
                            prefix = "\u001b[32m\u001b[1m";
                            break;
                        }
                        case '%': {
                            prefix = "\u001b[0m\u001b[37m\u001b[2m";
                            break;
                        }
                        case '$': {
                            prefix = "\u001b[36m\u001b[1m";
                            break;
                        }
                        case '~': {
                            prefix = "\u001b[35m\u001b[1m";
                            break;
                        }
                        case '=': {
                            prefix = "\u001b[42m";
                            break;
                        }
                        case '\u00f7': {
                            prefix = "\u001b[41m";
                            break;
                        }
                        default: {
                            this.printStream.print("\u00a7" + token);
                            continue block21;
                        }
                    }
                    if (prefix != null) {
                        this.printStream.print(prefix);
                    }
                    this.printStream.print(token);
                    continue;
                }
                if ("\u00a7".equals(token)) {
                    wasDelimiter = true;
                    continue;
                }
                wasDelimiter = false;
                this.printStream.print(token);
            }
            if (txt.indexOf(167) > -1) {
                this.printStream.print("\u001b[0m");
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

