/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import io.datatree.Tree;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import services.moleculer.ServiceBroker;
import services.moleculer.util.CheckedTree;

public abstract class Command {
    protected LinkedList<String[]> options = new LinkedList();

    public Command() {
        this.option("help", "output usage information");
    }

    public abstract String getDescription();

    public abstract String getUsage();

    public abstract int getNumberOfRequiredParameters();

    public abstract void onCommand(ServiceBroker var1, PrintWriter var2, String[] var3) throws Exception;

    protected void option(String option, String description) {
        this.options.add(new String[]{option, description});
    }

    protected Tree parseFlags(String[] parameters) throws Exception {
        return this.parseFlags(1, parameters, null);
    }

    protected Tree parseFlags(int from, String[] parameters, Collection<String> knownParams) {
        Tree flags = new Tree();
        String name = null;
        if (from < parameters.length) {
            boolean skipNext = false;
            int i = from;
            while (i < parameters.length) {
                String param = parameters[i];
                if (name == null) {
                    if (param.startsWith("--") && param.length() > 2) {
                        name = param.substring(2);
                        if (knownParams == null || knownParams.contains(name)) {
                            flags.put("lastIndex", i);
                            skipNext = false;
                        } else {
                            skipNext = true;
                        }
                    }
                } else if (param.startsWith("--") && param.length() > 2) {
                    flags.putObject(name, null);
                    name = param.substring(2);
                    if (knownParams == null || knownParams.contains(name)) {
                        flags.put("lastIndex", i);
                        skipNext = false;
                    } else {
                        skipNext = true;
                    }
                } else {
                    flags.put(name, param);
                    if (!skipNext) {
                        flags.put("lastIndex", i);
                    }
                    name = null;
                    skipNext = false;
                }
                ++i;
            }
            if (name != null) {
                flags.putObject(name, null);
            }
        }
        return flags;
    }

    protected Tree getPayload(String[] parameters) throws Exception {
        return this.getPayload(1, parameters);
    }

    protected Tree getPayload(int from, String[] parameters) throws Exception {
        if (parameters.length > from) {
            if (parameters[from].startsWith("'") || parameters[from].startsWith("{") || parameters[from].startsWith("[")) {
                StringBuilder tmp = new StringBuilder();
                int i = from;
                while (i < parameters.length) {
                    if (tmp.length() != 0) {
                        tmp.append(' ');
                    }
                    tmp.append(parameters[i]);
                    ++i;
                }
                String json = tmp.toString();
                if (json.startsWith("'")) {
                    json = json.substring(1);
                }
                if (json.endsWith("'")) {
                    json = json.substring(0, json.length() - 1);
                }
                return new Tree(json.trim());
            }
            Tree payload = new Tree();
            String name = null;
            int i = from;
            while (i < parameters.length) {
                String p = parameters[i];
                if (name == null) {
                    if (p.startsWith("--")) {
                        p = p.substring(2);
                    }
                    name = p;
                } else {
                    if ("true".equals(p)) {
                        payload.put(name, true);
                    } else if ("false".equals(p)) {
                        payload.put(name, false);
                    } else {
                        try {
                            if (p.contains(".")) {
                                payload.put(name, Double.parseDouble(p));
                            } else {
                                payload.put(name, Integer.parseInt(p));
                            }
                        }
                        catch (Exception exception) {
                            if (p.startsWith("\"") && p.endsWith("\"") || p.startsWith("'") && p.endsWith("'")) {
                                p = p.replace('\"', ' ').replace('\'', ' ').trim();
                            }
                            payload.put(name, p);
                        }
                    }
                    name = null;
                }
                ++i;
            }
            if (name != null && payload.isEmpty()) {
                if ("true".equals(name)) {
                    payload = new CheckedTree((Object)true);
                } else if ("false".equals(name)) {
                    payload = new CheckedTree((Object)false);
                } else {
                    try {
                        payload = name.contains(".") ? new CheckedTree((Object)Double.parseDouble(name)) : new CheckedTree((Object)Integer.parseInt(name));
                    }
                    catch (Exception exception) {
                        if (name.startsWith("\"") && name.endsWith("\"") || name.startsWith("'") && name.endsWith("'")) {
                            name = name.replace('\"', ' ').replace('\'', ' ').trim();
                        }
                        payload = new CheckedTree((Object)name);
                    }
                }
            }
            return payload;
        }
        return new Tree();
    }

    protected void printChars(StringBuilder out, char c, int repeats) {
        int i = 0;
        while (i < repeats) {
            out.append(c);
            ++i;
        }
    }
}

