/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import io.datatree.dom.Config;
import io.datatree.dom.builtin.JsonBuiltin;
import io.datatree.dom.converters.DataConverterRegistry;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JsonColorizer
extends JsonBuiltin {
    public String toString(Object value, Object meta, boolean pretty, boolean insertMeta) {
        if (value == null) {
            return "";
        }
        StringBuilder builder = (StringBuilder)this.builders.poll();
        if (builder == null) {
            builder = new StringBuilder(512);
        } else {
            builder.setLength(0);
        }
        builder.append("\u00a7%");
        JsonColorizer.toColorizedString(builder, value, insertMeta ? meta : null, pretty ? 1 : 0);
        String json = builder.toString();
        if (this.builders.size() > Config.POOL_SIZE) {
            return json;
        }
        this.builders.add(builder);
        return json;
    }

    protected static final void toColorizedString(StringBuilder builder, Object value, Object meta, int indent) {
        if (value == null) {
            builder.append("\u00a7+").append(NULL).append("\u00a7%");
            return;
        }
        if (value instanceof Number) {
            builder.append("\u00a7!").append(value).append("\u00a7%");
            return;
        }
        if (value instanceof Boolean) {
            builder.append("\u00a7~").append(value).append("\u00a7%");
            return;
        }
        if (value instanceof String) {
            builder.append("\u00a7'");
            JsonColorizer.appendString((StringBuilder)builder, (Object)value, (boolean)true);
            builder.append("\u00a7%");
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            int max = map.size();
            int pos = 0;
            int newIndent = indent == 0 ? 0 : indent + 1;
            builder.append('{');
            if (indent != 0) {
                JsonColorizer.appendIndent((StringBuilder)builder, (int)indent);
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry child;
                Map.Entry entry = child = iterator.next();
                JsonColorizer.appendString((StringBuilder)builder, entry.getKey(), (boolean)false);
                builder.append(':');
                JsonColorizer.toColorizedString(builder, entry.getValue(), null, newIndent);
                if (++pos >= max && meta == null) continue;
                builder.append(',');
                if (indent == 0) continue;
                JsonColorizer.appendIndent((StringBuilder)builder, (int)indent);
            }
            if (meta != null) {
                JsonColorizer.appendString((StringBuilder)builder, (Object)Config.META, (boolean)false);
                builder.append(':');
                JsonColorizer.toColorizedString(builder, meta, null, newIndent);
            }
            if (indent != 0) {
                JsonColorizer.appendIndent((StringBuilder)builder, (int)(indent - 1));
            }
            builder.append('}');
            return;
        }
        if (value instanceof Collection) {
            builder.append('[');
            if (indent != 0) {
                JsonColorizer.appendIndent((StringBuilder)builder, (int)indent);
            }
            Collection array = (Collection)value;
            int max = array.size();
            int pos = 0;
            int newIndent = indent == 0 ? 0 : indent + 1;
            for (Object child : array) {
                JsonColorizer.toColorizedString(builder, child, null, newIndent);
                if (++pos >= max) continue;
                builder.append(',');
                if (indent == 0) continue;
                JsonColorizer.appendIndent((StringBuilder)builder, (int)indent);
            }
            if (indent != 0) {
                JsonColorizer.appendIndent((StringBuilder)builder, (int)(indent - 1));
            }
            builder.append(']');
            return;
        }
        if (value instanceof byte[]) {
            builder.append("\u00a7$");
            builder.append('\"');
            builder.append((String)DataConverterRegistry.convert(String.class, (Object)value));
            builder.append('\"');
            builder.append("\u00a7%");
            return;
        }
        if (value.getClass().isArray()) {
            builder.append('[');
            if (indent != 0) {
                JsonColorizer.appendIndent((StringBuilder)builder, (int)indent);
            }
            int max = Array.getLength(value);
            int newIndent = indent == 0 ? 0 : indent + 1;
            int i = 0;
            while (i < max) {
                JsonColorizer.toColorizedString(builder, Array.get(value, i), null, newIndent);
                if (i < max - 1) {
                    builder.append(',');
                    if (indent != 0) {
                        JsonColorizer.appendIndent((StringBuilder)builder, (int)indent);
                    }
                }
                ++i;
            }
            if (indent != 0) {
                JsonColorizer.appendIndent((StringBuilder)builder, (int)(indent - 1));
            }
            builder.append(']');
            return;
        }
        JsonColorizer.appendString((StringBuilder)builder, (Object)value, (boolean)true);
    }
}

