/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import io.datatree.dom.PackageScanner;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.ColorWriter;
import services.moleculer.repl.Command;
import services.moleculer.repl.LocalReader;
import services.moleculer.repl.Repl;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;
import services.moleculer.util.CommonUtils;

@Name(value="Local REPL Console")
public class LocalRepl
extends Repl
implements Runnable {
    protected String[] packagesToScan = new String[0];
    protected ConcurrentHashMap<String, Command> commands = new ConcurrentHashMap(64);
    protected ConcurrentHashMap<String, Command> postDefinedCommands = new ConcurrentHashMap();
    protected ExecutorService executor;
    protected String lastCommand = "help";
    protected LocalReader reader;
    protected ColorWriter colorWriter = new ColorWriter();

    public LocalRepl() {
    }

    public LocalRepl(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Override
    public void started(ServiceBroker broker) throws Exception {
        super.started(broker);
        if (this.isEnabled()) {
            broker.getConfig().getExecutor().execute(() -> {
                try {
                    this.onCommand(new PrintWriter(new Writer(){

                        @Override
                        public void write(char[] cbuf, int off, int len) throws IOException {
                        }

                        @Override
                        public void flush() throws IOException {
                        }

                        @Override
                        public void close() throws IOException {
                        }
                    }), "info");
                }
                catch (Exception exception) {}
            });
        }
    }

    @Override
    protected void startReading() {
        this.commands.clear();
        this.load("Actions", "Broadcast", "BroadcastLocal", "Call", "Clear", "Close", "DCall", "Emit", "Env", "Events", "Exit", "Find", "Gc", "Info", "Memory", "Nodes", "Props", "Services", "Threads", "Bench", "Debug", "Ping", "Run");
        if (this.packagesToScan != null && this.packagesToScan.length > 0) {
            String[] stringArray = this.packagesToScan;
            int n = this.packagesToScan.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                if (!packageName.isEmpty()) {
                    try {
                        LinkedList classNames = PackageScanner.scan((String)packageName);
                        for (String className : classNames) {
                            Class<?> type;
                            if (className.indexOf(36) > -1 || !Command.class.isAssignableFrom(type = Class.forName(className = String.valueOf(packageName) + '.' + className))) continue;
                            Command command = (Command)type.newInstance();
                            String name = CommonUtils.nameOf((Object)command, (boolean)false).toLowerCase();
                            this.commands.put(name, command);
                            this.logger.info("Command \"" + name + "\" registered.");
                        }
                    }
                    catch (Throwable cause) {
                        this.logger.warn("Unable to scan Java package!", cause);
                    }
                }
                ++n2;
            }
        }
        this.commands.putAll(this.postDefinedCommands);
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception exception) {}
        }
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute(this);
        this.showStartMessage();
    }

    protected void load(String ... commands) {
        try {
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                String className = "services.moleculer.repl.commands." + command;
                Command impl = (Command)Class.forName(className).newInstance();
                String name = CommonUtils.nameOf((Object)impl, (boolean)false).toLowerCase();
                this.commands.put(name, impl);
                ++n2;
            }
        }
        catch (Throwable cause) {
            this.logger.warn("Unable to load command!", cause);
        }
    }

    protected void showStartMessage() {
        this.logger.info(String.valueOf(CommonUtils.nameOf((Object)this, (boolean)true)) + " started. Type \"help\" for list of commands.");
    }

    public void addCommand(Command command) {
        String name = CommonUtils.nameOf((Object)command, (boolean)false).toLowerCase();
        this.postDefinedCommands.put(name, command);
    }

    @Override
    public void run() {
        try {
            boolean showPrompt = false;
            while (this.executor != null && !Thread.currentThread().isInterrupted()) {
                this.reader = new LocalReader(showPrompt);
                if (!showPrompt) {
                    showPrompt = true;
                }
                this.reader.start();
                if (this.reader == null) {
                    return;
                }
                this.reader.join();
                String command = this.reader.getLine();
                if (command.length() > 2048) {
                    char first = command.charAt(0);
                    boolean sameChars = true;
                    int i = 1;
                    while (i < command.length() - 1) {
                        if (command.charAt(i) != first) {
                            sameChars = false;
                            break;
                        }
                        ++i;
                    }
                    if (sameChars) {
                        this.stopReading();
                        this.logger.info(String.valueOf(CommonUtils.nameOf((Object)this, (boolean)false)) + " interrupted.");
                        return;
                    }
                }
                this.reader = null;
                if (command.length() <= 0) continue;
                if ("r".equalsIgnoreCase(command) || "repeat".equalsIgnoreCase(command)) {
                    command = this.lastCommand;
                } else if ("q".equalsIgnoreCase(command)) {
                    command = "exit";
                }
                this.onCommand(new PrintWriter(this.colorWriter), command);
                this.lastCommand = command;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable cause) {
            cause.printStackTrace();
        }
    }

    @Override
    public void onCommand(PrintWriter out, String command) throws Exception {
        try {
            if (command == null) {
                return;
            }
            if ((command = command.trim()).length() == 0) {
                return;
            }
            String[] tokens = this.parseLine(command);
            String cmd = tokens[0].toLowerCase();
            out.println();
            if (tokens.length > 1 && tokens[1].equals("--help")) {
                this.printCommandHelp(out, tokens[0]);
                return;
            }
            if ("help".equals(cmd) || "?".equals(cmd)) {
                boolean telnet = false;
                if (tokens.length > 1) {
                    if (tokens[1].equals("telnet")) {
                        telnet = true;
                    } else {
                        this.printCommandHelp(out, tokens[1]);
                        return;
                    }
                }
                this.printHelp(out, telnet);
                out.println("  Type \"repeat\" or \"r\"  to repeat the execution of the last command.");
                out.println();
                return;
            }
            Command impl = this.commands.get(cmd);
            if (impl == null) {
                out.println("The \"" + cmd + "\" command is unknown.");
                if (cmd.length() > 1) {
                    int maxCount = 0;
                    String suggestion = "";
                    char[] chars = cmd.toCharArray();
                    for (String test : this.commands.keySet()) {
                        int count = 0;
                        char[] cArray = chars;
                        int n = chars.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char c = cArray[n2];
                            if (test.indexOf(c) > -1) {
                                ++count;
                            }
                            ++n2;
                        }
                        if (count <= maxCount && (count != maxCount || test.length() >= suggestion.length())) continue;
                        maxCount = count;
                        suggestion = test;
                    }
                    if (100 * maxCount / cmd.length() > 70) {
                        out.println("Type \"help\" to list of all supported commands.");
                        out.println("Do you mean \"" + suggestion + "\"?");
                        out.println();
                        this.printCommandHelp(out, suggestion);
                        return;
                    }
                }
                out.println();
                this.printHelp(out, false);
                out.println();
                return;
            }
            String[] args = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, args, 0, args.length);
            if (impl.getNumberOfRequiredParameters() > args.length) {
                out.println("Unable to call \"" + cmd + "\" command!");
                out.println("Too few command parameters (" + args.length + " < " + impl.getNumberOfRequiredParameters() + ")!");
                out.println();
                this.printCommandHelp(out, cmd);
                return;
            }
            impl.onCommand(this.broker, out, args);
            out.println();
        }
        catch (Exception cause) {
            out.println("Command execution failed!");
            cause.printStackTrace(out);
            out.println();
        }
    }

    protected String[] parseLine(String command) {
        int delimiter = ' ';
        boolean inToken = false;
        StringBuilder writer = new StringBuilder(100);
        LinkedList<String> tokens = new LinkedList<String>();
        int i = 0;
        while (i < command.length()) {
            block10: {
                block11: {
                    char c;
                    block8: {
                        block9: {
                            c = command.charAt(i);
                            if (!inToken) break block8;
                            if (c != delimiter) break block9;
                            tokens.add(writer.toString());
                            writer.setLength(0);
                            if (c == '-') {
                                writer.append(c);
                            }
                            inToken = false;
                            break block10;
                        }
                        writer.append(c);
                        break block11;
                    }
                    if (c == '\'') {
                        delimiter = 39;
                        inToken = true;
                    } else if (c == '\"') {
                        delimiter = 34;
                        inToken = true;
                    } else if (c != ' ') {
                        delimiter = 32;
                        writer.append(c);
                        inToken = true;
                    }
                }
                if (i == command.length() - 1 && writer.length() != 0) {
                    tokens.add(writer.toString());
                }
            }
            ++i;
        }
        String[] array = new String[tokens.size()];
        tokens.toArray(array);
        return array;
    }

    protected void printHelp(PrintWriter out, boolean telnet) {
        String[] names = new String[this.commands.size()];
        ((ConcurrentHashMap.CollectionView)((Object)this.commands.keySet())).toArray(names);
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        TextTable table = new TextTable(false, "Command", "Description");
        table.setPadding(2);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (telnet || !name.equals("close")) {
                Command impl = this.commands.get(name);
                table.addRow(impl.getUsage(), impl.getDescription());
            }
            ++n2;
        }
        out.println("Commands:");
        out.println();
        out.println(table);
    }

    protected void printCommandHelp(PrintWriter out, String name) {
        Command impl = this.commands.get(name);
        if (impl == null) {
            out.println("The \"" + name + "\" command is unknown!");
            out.println("Type \"help\" for more information.");
            return;
        }
        out.println("  Usage: " + impl.getUsage());
        out.println();
        out.println("  " + impl.getDescription());
        out.println();
        out.println("  Options:");
        out.println();
        TextTable table = new TextTable(false, "Option", "Description");
        table.setPadding(2);
        for (String[] option : impl.options) {
            table.addRow("  --" + option[0], option[1]);
        }
        out.println(table);
        out.println();
    }

    @Override
    protected void stopReading() {
        if (this.reader != null) {
            LocalReader r = this.reader;
            this.reader = null;
            try {
                r.interrupt();
            }
            catch (Exception exception) {}
        }
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception exception) {}
            this.executor = null;
        }
        this.commands.clear();
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }
}

