/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import services.moleculer.repl.ColorWriter;
import services.moleculer.repl.RemoteRepl;
import services.moleculer.repl.commands.Info;

public class RemoteReader {
    private static final ByteBuffer requestBuffer = ByteBuffer.allocate(1);
    protected static final byte[] LINE_BREAK = new byte[]{10, 13};
    protected static final byte[] BACKSPACE = new byte[]{8, 32, 8};
    protected static final byte[] HIGHLIGHT = "\u001b[1m".getBytes();
    protected static final byte[] NORMAL = "\u001b[0m".getBytes();
    protected final RemoteRepl remoteRepl;
    protected final SocketChannel channel;
    protected final SelectionKey key;
    protected final boolean echo;
    protected final String username;
    protected final String password;
    protected boolean maskPassword;
    protected boolean loggedOn;
    protected byte skip;
    protected static final int MAX_LEN = 1000;
    protected char[] request = new char[1000];
    protected int counter = 0;
    protected final LinkedList<ByteBuffer> responseBuffers = new LinkedList();
    protected ByteBuffer currentBuffer;
    protected String enteredName;
    protected String lastCommand = "help";

    public RemoteReader(RemoteRepl remoteRepl, SocketChannel channel, SelectionKey key, boolean authenticated, boolean echo, String username, String password) {
        this.remoteRepl = remoteRepl;
        this.channel = channel;
        this.key = key;
        this.echo = echo;
        this.username = username;
        this.password = password;
        this.loggedOn = !authenticated;
        String header = "Moleculer Microservice Framework V" + Info.getSoftwareVersion();
        int len = (79 - header.length()) / 2;
        String spaces = "                                                                               ";
        String title = String.valueOf(spaces.substring(0, len)) + header + spaces.substring(0, len);
        if (title.length() < 79) {
            title = String.valueOf(title) + " ";
        }
        header = "\u001b[7m" + spaces + "\r\n" + title + "\r\n" + spaces + "\u001b[0m\r\n\r\n";
        if (!this.loggedOn) {
            header = String.valueOf(header) + "Username:";
        } else {
            header = String.valueOf(header) + "Welcome anonymous!\r\nType \"help\" for more information.\r\n\r\n";
            header = String.valueOf(header) + "mol $ ";
        }
        this.addString(header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPacket() {
        try {
            ByteBuffer byteBuffer = requestBuffer;
            synchronized (byteBuffer) {
                requestBuffer.clear();
                int len = this.channel.read(requestBuffer);
                if (len == -1) {
                    throw new IOException();
                }
                if (len == 1) {
                    int read = requestBuffer.array()[0] & 0xFF;
                    if (this.skip != 0) {
                        this.skip = (byte)(this.skip - 1);
                        return;
                    }
                    if (read == 255) {
                        this.skip = (byte)2;
                        return;
                    }
                    char c = (char)read;
                    if (c > '\u001f' && c < '\u0080' || c == '\r' || c == '\n' || c == '\b') {
                        if (c == '\n') {
                            return;
                        }
                        if (c == '\r') {
                            if (this.echo) {
                                this.addBytes(LINE_BREAK, true);
                            }
                            if (this.counter != 0) {
                                String commandLine = new String(this.request, 0, this.counter);
                                if ((commandLine = commandLine.trim()).length() != 0) {
                                    this.processCommand(commandLine);
                                }
                            }
                            this.counter = 0;
                        } else if (c == '\b') {
                            if (this.counter > 0) {
                                if (this.echo) {
                                    this.addBytes(BACKSPACE, true);
                                }
                                --this.counter;
                            }
                        } else {
                            if (this.echo) {
                                this.addBytes(HIGHLIGHT, true);
                                if (this.maskPassword) {
                                    this.addChar('*');
                                } else {
                                    this.addChar(c);
                                }
                                this.addBytes(NORMAL, true);
                            }
                            this.request[this.counter] = c;
                            ++this.counter;
                            if (this.counter == 1000) {
                                this.addString("Too long row!", true);
                                this.counter = 0;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePacket() {
        try {
            LinkedList<ByteBuffer> linkedList;
            if (this.currentBuffer == null) {
                linkedList = this.responseBuffers;
                synchronized (linkedList) {
                    if (this.responseBuffers.isEmpty()) {
                        this.key.interestOps(1);
                        return;
                    }
                    this.currentBuffer = this.responseBuffers.removeFirst();
                }
            }
            this.channel.write(this.currentBuffer);
            if (this.currentBuffer.hasRemaining()) {
                linkedList = this.responseBuffers;
                synchronized (linkedList) {
                    if (this.responseBuffers.isEmpty()) {
                        this.key.interestOps(1);
                    }
                }
                return;
            }
            this.currentBuffer = null;
        }
        catch (Exception exception) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChar(char c) {
        byte[] bytes = new byte[]{(byte)c};
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        LinkedList<ByteBuffer> linkedList = this.responseBuffers;
        synchronized (linkedList) {
            this.responseBuffers.addLast(buffer);
            this.key.interestOps(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBytes(byte[] bytes, boolean directSet) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        LinkedList<ByteBuffer> linkedList = this.responseBuffers;
        synchronized (linkedList) {
            this.responseBuffers.addLast(buffer);
            if (directSet) {
                this.key.interestOps(4);
            } else {
                this.remoteRepl.markAsWritable(this.key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addString(String string, boolean directSet) {
        byte[] bytes = null;
        try {
            bytes = string.getBytes(StandardCharsets.US_ASCII);
        }
        catch (Exception exception) {
            bytes = string.getBytes();
        }
        if (bytes != null) {
            try {
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                LinkedList<ByteBuffer> linkedList = this.responseBuffers;
                synchronized (linkedList) {
                    this.responseBuffers.addLast(buffer);
                    if (directSet) {
                        this.key.interestOps(4);
                    } else {
                        this.remoteRepl.markAsWritable(this.key);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {}
        }
        this.remoteRepl.removeBuffer(this);
    }

    protected void processCommand(String command) throws Exception {
        if (!this.loggedOn) {
            if (this.enteredName == null) {
                this.enteredName = command;
                this.maskPassword = true;
                this.addString("Password:", true);
                return;
            }
            this.maskPassword = false;
            String error = null;
            if (!this.enteredName.equals(this.username)) {
                error = "Unknown user!";
            } else if (!this.password.equals(command)) {
                error = "Invalid password for " + this.enteredName + "!";
            }
            if (error != null) {
                error = "\r\n\r\nAccess denied! " + error + '\u0007';
                this.channel.write(ByteBuffer.wrap(error.getBytes(StandardCharsets.US_ASCII)));
                Thread.sleep(1000L);
                this.close();
                return;
            }
            this.addString("\r\nWelcome " + this.enteredName + "!\r\nType \"help\" for more information.\r\nmol $ ", true);
            this.loggedOn = true;
            return;
        }
        if (command.equalsIgnoreCase("close")) {
            this.close();
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)baos, true, "US-ASCII");
        ColorWriter colorWriter = new ColorWriter(printStream);
        PrintWriter printWriter = new PrintWriter((Writer)colorWriter, true);
        if ("r".equalsIgnoreCase(command) || "repeat".equalsIgnoreCase(command)) {
            command = this.lastCommand;
        }
        if (command.equals("help") || command.startsWith("nodes") || command.startsWith("actions")) {
            command = String.valueOf(command) + " telnet";
        }
        this.remoteRepl.onCommand(printWriter, command);
        printWriter.print("mol $ ");
        this.lastCommand = command;
        this.addBytes(baos.toByteArray(), true);
    }
}

