/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import services.moleculer.repl.LocalRepl;
import services.moleculer.repl.RemoteReader;
import services.moleculer.service.Name;
import services.moleculer.util.CommonUtils;

@Name(value="Remote REPL Console")
public class RemoteRepl
extends LocalRepl {
    protected static final byte[] TELNET_HEADER = new byte[]{-1, -5, 1, -1, -2, 3, -1, -4, 33};
    protected int port = 23;
    protected boolean echo = true;
    protected int socketTimeout;
    protected int maxSessions = 8;
    protected boolean authenticated = true;
    protected String username = "admin";
    protected String password = "admin";
    protected final LinkedList<RemoteReader> buffers = new LinkedList();
    protected final LinkedList<SelectionKey> writableKeys = new LinkedList();
    protected ServerSocketChannel serverChannel;
    protected Selector selector;

    @Override
    protected void startReading() {
        try {
            this.serverChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = this.serverChannel.socket();
            serverSocket.bind(new InetSocketAddress(this.port));
            this.serverChannel.configureBlocking(false);
            this.selector = Selector.open();
            this.serverChannel.register(this.selector, 16);
            super.startReading();
        }
        catch (Exception cause) {
            this.logger.error("Unable to start telnet!", (Throwable)cause);
        }
    }

    @Override
    protected void showStartMessage() {
        this.logger.info(String.valueOf(CommonUtils.nameOf((Object)this, (boolean)true)) + " started. Type \"telnet " + CommonUtils.getHostName() + ' ' + this.port + "\" to connect.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel channel = null;
        while (this.executor != null && !Thread.currentThread().isInterrupted()) {
            int n;
            try {
                if (this.selector == null) continue;
                n = this.selector.select();
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (Exception exception) {
                break;
            }
            if (n > 0) {
                Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
                while (keys.hasNext()) {
                    SelectionKey key = keys.next();
                    if (key == null) continue;
                    if (key.isValid()) {
                        RemoteReader buffer;
                        if (key.isAcceptable()) {
                            block39: {
                                try {
                                    if (this.serverChannel == null) break block39;
                                    channel = this.serverChannel.accept();
                                }
                                catch (IOException iOException) {
                                    keys.remove();
                                    continue;
                                }
                            }
                            if (channel != null) {
                                try {
                                    int openedSessions;
                                    LinkedList<RemoteReader> linkedList = this.buffers;
                                    synchronized (linkedList) {
                                        openedSessions = this.buffers.size();
                                    }
                                    if (openedSessions >= this.maxSessions) {
                                        throw new Exception("too much opened maxSessions");
                                    }
                                    Socket socket = channel.socket();
                                    if (this.socketTimeout > 0) {
                                        socket.setSoTimeout(this.socketTimeout);
                                    }
                                    channel.configureBlocking(false);
                                    SelectionKey newKey = channel.register(this.selector, 0);
                                    buffer = new RemoteReader(this, channel, newKey, this.authenticated, this.echo, this.username, this.password);
                                    newKey.attach(buffer);
                                    LinkedList<RemoteReader> linkedList2 = this.buffers;
                                    synchronized (linkedList2) {
                                        this.buffers.addLast(buffer);
                                    }
                                    if (this.echo) {
                                        buffer.addBytes(TELNET_HEADER, true);
                                    }
                                }
                                catch (IOException iOException) {
                                    try {
                                        channel.close();
                                    }
                                    catch (Exception exception) {}
                                    keys.remove();
                                    continue;
                                }
                                catch (Exception e4) {
                                    try {
                                        String message = "Telnet connection refused: " + e4.getMessage();
                                        try {
                                            ByteBuffer msg = ByteBuffer.wrap(message.getBytes(StandardCharsets.US_ASCII));
                                            channel.write(msg);
                                            Thread.sleep(1000L);
                                        }
                                        catch (Exception exception) {}
                                        channel.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        } else if (key.isReadable()) {
                            buffer = (RemoteReader)key.attachment();
                            if (buffer != null) {
                                buffer.readPacket();
                            }
                        } else if (key.isWritable() && (buffer = (RemoteReader)key.attachment()) != null) {
                            buffer.writePacket();
                        }
                    }
                    keys.remove();
                }
            }
            LinkedList<SelectionKey> linkedList = this.writableKeys;
            synchronized (linkedList) {
                if (!this.writableKeys.isEmpty()) {
                    for (SelectionKey key : this.writableKeys) {
                        if (key == null || !key.isValid()) continue;
                        key.interestOps(4);
                    }
                    this.writableKeys.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuffer(RemoteReader buffer) {
        LinkedList<RemoteReader> linkedList = this.buffers;
        synchronized (linkedList) {
            this.buffers.remove(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAsWritable(SelectionKey key) {
        LinkedList<SelectionKey> linkedList = this.writableKeys;
        synchronized (linkedList) {
            this.writableKeys.addLast(key);
        }
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopReading() {
        super.stopReading();
        if (this.selector != null) {
            try {
                this.selector.wakeup();
                if (this.serverChannel != null) {
                    this.serverChannel.close();
                }
                this.selector.close();
            }
            catch (Exception exception) {}
            this.serverChannel = null;
            this.selector = null;
        }
        LinkedList<RemoteReader> linkedList = this.buffers;
        synchronized (linkedList) {
            if (!this.buffers.isEmpty()) {
                RemoteReader[] array = new RemoteReader[this.buffers.size()];
                this.buffers.toArray(array);
                int n = 0;
                while (n < array.length) {
                    array[n].close();
                    ++n;
                }
            }
        }
        this.writableKeys.clear();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int sessions) {
        this.maxSessions = sessions;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

