/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import io.datatree.dom.TreeWriter;
import io.datatree.dom.TreeWriterRegistry;
import java.io.PrintWriter;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.JsonColorizer;
import services.moleculer.service.Name;
import services.moleculer.service.Service;
import services.moleculer.util.CommonUtils;

@Name(value="REPL Console")
public abstract class Repl
extends Service {
    private boolean enabled = true;
    private volatile boolean running;

    static {
        TreeWriterRegistry.setWriter((String)"colorized-json", (TreeWriter)new JsonColorizer());
    }

    public void started(ServiceBroker broker) throws Exception {
        super.started(broker);
        this.startOrStopReading();
    }

    protected synchronized void startOrStopReading() {
        if (this.running) {
            if (!this.enabled) {
                this.stopNow();
            }
        } else if (this.enabled) {
            try {
                this.startReading();
                this.running = true;
            }
            catch (Throwable cause) {
                this.logger.error("Unable to start console!", cause);
            }
        }
    }

    protected synchronized void stopNow() {
        try {
            this.stopReading();
            this.logger.info(String.valueOf(CommonUtils.nameOf((Object)((Object)this), (boolean)true)) + " stopped.");
        }
        catch (Throwable cause) {
            this.logger.error("Unable to stop console!", cause);
        }
        this.running = false;
    }

    public void stopped() {
        this.stopNow();
    }

    protected abstract void startReading();

    protected abstract void stopReading();

    public abstract void onCommand(PrintWriter var1, String var2) throws Exception;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.startOrStopReading();
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

