/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TextTable {
    private int padding = 1;
    private String newLine = System.getProperty("line.separator", "\r\n");
    private char jointSymbol = (char)43;
    private char vSplitSymbol = (char)124;
    private char hSplitSymbol = (char)45;
    private final boolean drawGridAndHeader;
    protected final List<String> headersList;
    private List<List<String>> rowsList = new LinkedList<List<String>>();

    public TextTable(String ... headers) {
        this(true, headers);
    }

    public TextTable(boolean drawGridAndHeader, String ... headers) {
        this.drawGridAndHeader = drawGridAndHeader;
        this.headersList = Arrays.asList(headers);
    }

    public void addRow(String ... cells) {
        this.addRow(false, Arrays.asList(cells));
    }

    public void addRow(boolean checkLength, String ... cells) {
        this.addRow(checkLength, Arrays.asList(cells));
    }

    public void addRow(List<String> cells) {
        this.addRow(false, cells);
    }

    public void addRow(boolean checkLength, List<String> cells) {
        String last = cells.get(cells.size() - 1);
        if (!checkLength || last.length() <= 40) {
            this.rowsList.add(cells);
        } else {
            boolean first = true;
            while (!last.isEmpty()) {
                int max = Math.min(last.length(), 40);
                String part = last.substring(0, max);
                last = last.substring(max);
                if (first) {
                    first = false;
                    cells.set(cells.size() - 1, part);
                    this.rowsList.add(cells);
                    continue;
                }
                LinkedList<String> list = new LinkedList<String>();
                int i = 0;
                while (i < cells.size() - 1) {
                    list.add("");
                    ++i;
                }
                list.add(part);
                this.rowsList.add(list);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<Integer, Integer> columnMaxWidthMapping = this.getMaximumWidhtofTable(this.headersList, this.rowsList);
        if (this.drawGridAndHeader) {
            this.createRowLine(stringBuilder, this.headersList.size(), columnMaxWidthMapping);
            stringBuilder.append(this.newLine);
            int headerIndex = 0;
            while (headerIndex < this.headersList.size()) {
                this.fillCell(stringBuilder, this.headersList.get(headerIndex), headerIndex, columnMaxWidthMapping, true, "\u00a7+");
                ++headerIndex;
            }
            stringBuilder.append(this.newLine);
            this.createRowLine(stringBuilder, this.headersList.size(), columnMaxWidthMapping);
            stringBuilder.append(this.newLine);
        }
        for (List<String> row : this.rowsList) {
            int cellIndex = 0;
            while (cellIndex < row.size()) {
                String cell = row.get(cellIndex);
                boolean centered = "OK".equals(cell) || "FAILED".equals(cell) || "Yes".equals(cell) || "No".equals(cell) || "ONLINE".equals(cell) || "OFFLINE".equals(cell);
                this.fillCell(stringBuilder, cell, cellIndex, columnMaxWidthMapping, centered, null);
                ++cellIndex;
            }
            stringBuilder.append(this.newLine);
        }
        if (this.drawGridAndHeader) {
            this.createRowLine(stringBuilder, this.headersList.size(), columnMaxWidthMapping);
        }
        return stringBuilder.toString();
    }

    protected void fillSpace(StringBuilder stringBuilder, int length) {
        int i = 0;
        while (i < length) {
            stringBuilder.append(" ");
            ++i;
        }
    }

    protected void createRowLine(StringBuilder stringBuilder, int headersListSize, Map<Integer, Integer> columnMaxWidthMapping) {
        stringBuilder.append("\u00a7%");
        int i = 0;
        while (i < headersListSize) {
            if (i == 0) {
                stringBuilder.append(this.jointSymbol);
            }
            int j = 0;
            while (j < columnMaxWidthMapping.get(i) + this.padding * 2) {
                stringBuilder.append(this.hSplitSymbol);
                ++j;
            }
            stringBuilder.append(this.jointSymbol);
            ++i;
        }
    }

    protected Map<Integer, Integer> getMaximumWidhtofTable(List<String> headersList, List<List<String>> rowsList) {
        HashMap<Integer, Integer> columnMaxWidthMapping = new HashMap<Integer, Integer>();
        int columnIndex = 0;
        while (columnIndex < headersList.size()) {
            columnMaxWidthMapping.put(columnIndex, 0);
            ++columnIndex;
        }
        columnIndex = 0;
        while (columnIndex < headersList.size()) {
            if (headersList.get(columnIndex).length() > (Integer)columnMaxWidthMapping.get(columnIndex)) {
                columnMaxWidthMapping.put(columnIndex, headersList.get(columnIndex).length());
            }
            ++columnIndex;
        }
        for (List<String> row : rowsList) {
            int columnIndex2 = 0;
            while (columnIndex2 < row.size()) {
                if (row.get(columnIndex2).length() > (Integer)columnMaxWidthMapping.get(columnIndex2)) {
                    columnMaxWidthMapping.put(columnIndex2, row.get(columnIndex2).length());
                }
                ++columnIndex2;
            }
        }
        columnIndex = 0;
        while (columnIndex < headersList.size()) {
            if ((Integer)columnMaxWidthMapping.get(columnIndex) % 2 != 0) {
                columnMaxWidthMapping.put(columnIndex, (Integer)columnMaxWidthMapping.get(columnIndex) + 1);
            }
            ++columnIndex;
        }
        return columnMaxWidthMapping;
    }

    protected int getOptimumCellPadding(int cellIndex, int datalength, Map<Integer, Integer> columnMaxWidthMapping, int cellPaddingSize) {
        if (datalength % 2 != 0) {
            ++datalength;
        }
        if (datalength < columnMaxWidthMapping.get(cellIndex)) {
            cellPaddingSize += (columnMaxWidthMapping.get(cellIndex) - datalength) / 2;
        }
        return cellPaddingSize;
    }

    protected void fillCell(StringBuilder stringBuilder, String cell, int cellIndex, Map<Integer, Integer> columnMaxWidthMapping, boolean centered, String color) {
        int cellPaddingSize = this.getOptimumCellPadding(cellIndex, cell.length(), columnMaxWidthMapping, this.padding);
        if (cellIndex == 0 && this.drawGridAndHeader) {
            stringBuilder.append("\u00a7%");
            stringBuilder.append(this.vSplitSymbol);
        }
        if ("OK".equals(cell) || "ONLINE".equals(cell)) {
            stringBuilder.append("\u00a7=");
        } else if ("FAILED".equals(cell) || "OFFLINE".equals(cell)) {
            stringBuilder.append("\u00a7\u00f7");
        }
        if (centered) {
            this.fillSpace(stringBuilder, cellPaddingSize);
            if (color != null) {
                stringBuilder.append(color);
            }
            stringBuilder.append(cell);
            if (cell.length() % 2 != 0) {
                stringBuilder.append(' ');
            }
            this.fillSpace(stringBuilder, cellPaddingSize);
        } else {
            this.fillSpace(stringBuilder, this.padding);
            stringBuilder.append(cell);
            if (cell.length() % 2 != 0) {
                stringBuilder.append(' ');
            }
            this.fillSpace(stringBuilder, 2 * cellPaddingSize - this.padding);
        }
        if (this.drawGridAndHeader) {
            stringBuilder.append("\u00a7%");
            stringBuilder.append(this.vSplitSymbol);
        }
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public void setJointSymbol(char jointSymbol) {
        this.jointSymbol = jointSymbol;
    }

    public void setvSplitSymbol(char vSplitSymbol) {
        this.vSplitSymbol = vSplitSymbol;
    }

    public void sethSplitSymbol(char hSplitSymbol) {
        this.hSplitSymbol = hSplitSymbol;
    }
}

