/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;
import services.moleculer.transporter.Transporter;
import services.moleculer.util.CommonUtils;

@Name(value="actions")
public class Actions
extends Command {
    public Actions() {
        this.options.clear();
        this.option("local, -l", "only local actions");
        this.option("skipinternal, -i", "skip internal actions");
        this.option("details, -d", "print endpoints");
        this.option("all, -a", "list all (offline) actions");
    }

    @Override
    public String getDescription() {
        return "List of actions";
    }

    @Override
    public String getUsage() {
        return "actions [options]";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        List<String> params = Arrays.asList(parameters);
        boolean local = params.contains("--local") || params.contains("-l");
        boolean skipinternal = params.contains("--skipinternal") || params.contains("-i");
        boolean details = params.contains("--details") || params.contains("-d");
        boolean all = params.contains("--all") || params.contains("-a");
        boolean telnet = params.contains("telnet");
        Transporter transporter = broker.getConfig().getTransporter();
        Tree infos = CommonUtils.getNodeInfos((ServiceBroker)broker, (Transporter)transporter);
        String localNodeID = broker.getNodeID();
        HashMap<String, HashMap<String, Tree>> actionMap = new HashMap<String, HashMap<String, Tree>>(512);
        for (Tree info : infos) {
            String nodeID = info.getName();
            Tree services = info.get("services");
            if (services == null || services.isNull()) continue;
            for (Tree service : services) {
                Tree actions = service.get("actions");
                if (actions == null || actions.isNull()) continue;
                for (Tree action : actions) {
                    action.put("nodeID", nodeID);
                    String actionName = action.get("name", "unknown");
                    HashMap<String, Tree> configs = (HashMap<String, Tree>)actionMap.get(actionName);
                    if (configs == null) {
                        configs = new HashMap<String, Tree>(64);
                        actionMap.put(actionName, configs);
                    }
                    configs.put(nodeID, action);
                }
            }
        }
        String[] actionNames = new String[actionMap.size()];
        actionMap.keySet().toArray(actionNames);
        Arrays.sort(actionNames, String.CASE_INSENSITIVE_ORDER);
        TextTable table = telnet ? new TextTable("Action", "Nodes", "State", "Cached") : new TextTable("Action", "Nodes", "State", "Cached", "Params");
        String[] stringArray = actionNames;
        int n = actionNames.length;
        int n2 = 0;
        while (n2 < n) {
            block25: {
                Object nodeID;
                String nodes;
                HashMap configs;
                ArrayList<String> row;
                block27: {
                    block26: {
                        String actionName = stringArray[n2];
                        if (skipinternal && actionName.startsWith("$")) break block25;
                        row = new ArrayList<String>(5);
                        configs = (HashMap)actionMap.get(actionName);
                        if (configs == null) break block25;
                        row.add(actionName);
                        nodes = Integer.toString(configs.size());
                        if (!configs.containsKey(localNodeID)) break block26;
                        nodes = "(*) " + nodes;
                        break block27;
                    }
                    if (local) break block25;
                }
                row.add(nodes);
                boolean online = false;
                for (Tree config : configs.values()) {
                    nodeID = config.get("nodeID", localNodeID);
                    if (transporter == null) {
                        online = true;
                        break;
                    }
                    online = transporter.isOnline((String)nodeID);
                    if (online) break;
                }
                if (all || online) {
                    row.add(online ? "OK" : "FAILED");
                    boolean cache = false;
                    for (Tree config : configs.values()) {
                        if (!config.get("cache", false)) continue;
                        cache = true;
                        break;
                    }
                    row.add(cache ? "Yes" : "No");
                    if (!telnet) {
                        HashSet<String> paramSet = new HashSet<String>();
                        for (Tree config : configs.values()) {
                            Tree paramsBlock = config.get("params");
                            if (paramsBlock == null || paramsBlock.isNull()) continue;
                            for (Tree param : paramsBlock) {
                                paramSet.add(param.getName());
                            }
                        }
                        String[] paramArray = new String[paramSet.size()];
                        paramSet.toArray(paramArray);
                        Arrays.sort(paramArray, String.CASE_INSENSITIVE_ORDER);
                        StringBuilder paramList = new StringBuilder(64);
                        String[] stringArray2 = paramArray;
                        int n3 = paramArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String param = stringArray2[n4];
                            if (paramList.length() > 0) {
                                paramList.append(", ");
                            }
                            paramList.append(param);
                            ++n4;
                        }
                        row.add(paramList.toString());
                    }
                    table.addRow(row);
                    if (details) {
                        String[] nodeIDArray = new String[configs.size()];
                        configs.keySet().toArray(nodeIDArray);
                        Arrays.sort(nodeIDArray, String.CASE_INSENSITIVE_ORDER);
                        String[] stringArray3 = nodeIDArray;
                        int n5 = nodeIDArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            nodeID = stringArray3[n6];
                            if (localNodeID.equals(nodeID)) {
                                if (telnet) {
                                    table.addRow("", "<local>", "OK", "");
                                } else {
                                    table.addRow("", "<local>", "OK", "", "");
                                }
                            } else {
                                boolean bl = online = transporter == null ? true : transporter.isOnline((String)nodeID);
                                if (telnet) {
                                    table.addRow(new String[]{"", nodeID, online ? "OK" : "FAILED", ""});
                                } else {
                                    table.addRow(new String[]{"", nodeID, online ? "OK" : "FAILED", "", ""});
                                }
                            }
                            ++n6;
                        }
                    }
                }
            }
            ++n2;
        }
        out.println(table);
    }
}

