/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import services.moleculer.ServiceBroker;
import services.moleculer.context.CallOptions;
import services.moleculer.error.ServiceNotAvailableError;
import services.moleculer.error.ServiceNotFoundError;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;
import services.moleculer.util.CommonUtils;

@Name(value="bench")
public class Bench
extends Command {
    protected ScheduledFuture<?> timer;
    protected ExecutorService executor;

    public Bench() {
        this.option("num <number>", "number of iterates");
        this.option("time <seconds>", "time of bench");
        this.option("nodeID <nodeID>", "nodeID (direct call)");
        this.option("max <number>", "max number of pending requests");
        this.option("retry <number>", "max number of retries (default is 0)");
    }

    @Override
    public String getDescription() {
        return "Benchmark a service";
    }

    @Override
    public String getUsage() {
        return "bench <action> [jsonParams]";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        this.executor = broker.getConfig().getExecutor();
        if (parameters[0].startsWith("--")) {
            out.println("Invalid parameter sequence! Examples of appropriate \"bench\" commands:");
            out.println();
            out.println("bench $node.list --num 100");
            out.println("bench $node.list --num 100 --nodeID node1");
            out.println("bench $node.list --time 10");
            out.println("bench $node.list --time 10 --max 10");
            out.println("bench $node.actions --time 120 {\"onlyLocal\":true}");
            out.println("bench $node.actions --time 120 onlyLocal true");
            return;
        }
        String action = parameters[0];
        List<String> knownParams = Arrays.asList("num", "time", "nodeID", "max", "retry");
        Tree flags = this.parseFlags(1, parameters, knownParams);
        long num = flags.get("num", 0);
        long time = flags.get("time", 0);
        int retry = flags.get("retry", 0);
        String nodeID = flags.get("nodeID", "");
        int lastIndex = flags.get("lastIndex", 0);
        int max = flags.get("max", 100);
        if (num > 0L) {
            max = Math.min(max, (int)num);
        }
        Tree params = this.getPayload(lastIndex + 1, parameters);
        if (num < 1L && time < 1L) {
            time = 5L;
        }
        if (max < 1) {
            max = 1;
        }
        CallOptions.Options opts = CallOptions.retryCount((int)retry);
        if (nodeID != null && !nodeID.isEmpty()) {
            opts = opts.nodeID(nodeID);
        }
        BenchData data = new BenchData(broker, opts, out, action, params, num);
        if (this.timer != null) {
            this.timer.cancel(true);
        }
        this.timer = broker.getConfig().getScheduler().schedule(() -> benchData.timeout.set(true), time < 1L ? 60L : time, TimeUnit.SECONDS);
        String msg = num > 0L ? String.valueOf(num) + " times" : "for " + CommonUtils.formatNamoSec((long)(time * 1000000000L));
        out.println("\u00a7!>> Calling '" + action + "' " + msg + " with params: " + params.toString("colorized-json", false));
        out.println();
        while (!data.finished.get()) {
            long res;
            long req = data.reqCount.get();
            if (req - (res = data.resCount.get()) < (long)max) {
                this.doRequest(broker, data);
                continue;
            }
            Thread.sleep(1L);
        }
        Thread.sleep(100L);
    }

    protected void doRequest(ServiceBroker broker, BenchData data) {
        data.reqCount.incrementAndGet();
        long startTime = System.nanoTime();
        try {
            broker.call(data.action, data.params, data.opts).then(res -> this.handleResponse(broker, data, startTime, null)).catchError(cause -> this.handleResponse(broker, data, startTime, (Throwable)cause));
        }
        catch (Exception err) {
            this.handleResponse(broker, data, startTime, err);
        }
    }

    protected void handleResponse(ServiceBroker broker, BenchData data, long startTime, Throwable cause) {
        if (data.finished.get()) {
            return;
        }
        long duration = System.nanoTime() - startTime;
        data.sumTime.addAndGet(duration);
        long count = data.resCount.incrementAndGet();
        if (cause != null) {
            Throwable type;
            if (data.errorCount.incrementAndGet() == 1L) {
                data.cause = cause;
            }
            if ((type = cause instanceof CompletionException ? ((CompletionException)cause).getCause() : cause) instanceof ServiceNotFoundError || type instanceof ServiceNotAvailableError) {
                if (data.finished.compareAndSet(false, true) && this.timer != null) {
                    this.timer.cancel(true);
                }
                return;
            }
        }
        long currentMin = data.minTime.get();
        while (duration < currentMin && !data.minTime.compareAndSet(currentMin, duration)) {
            currentMin = data.minTime.get();
        }
        long currentMax = data.maxTime.get();
        while (duration > currentMax && !data.maxTime.compareAndSet(currentMax, duration)) {
            currentMax = data.maxTime.get();
        }
        if (data.timeout.get() || data.num > 0L && count >= data.num) {
            if (data.finished.compareAndSet(false, true)) {
                if (this.timer != null) {
                    this.timer.cancel(true);
                }
                this.printResult(data);
            }
            return;
        }
        if (count % 100L > 0L) {
            this.doRequest(broker, data);
        } else {
            this.executor.execute(() -> this.doRequest(broker, data));
        }
    }

    protected void printResult(BenchData data) {
        PrintWriter out = data.out;
        try {
            String errStr;
            long now = System.nanoTime();
            BigDecimal errorCount = new BigDecimal(data.errorCount.get());
            BigDecimal resCount = new BigDecimal(data.resCount.get());
            BigDecimal sumTime = new BigDecimal(data.sumTime.get());
            long total = now - data.startTime;
            BigDecimal totalTime = new BigDecimal(total);
            BigDecimal nano = new BigDecimal(1000000000);
            BigDecimal reqPerSec = nano.multiply(resCount).divide(totalTime, RoundingMode.HALF_UP);
            long reqPer = Long.parseLong(reqPerSec.toBigInteger().toString());
            BigDecimal duration = sumTime.divide(resCount, RoundingMode.HALF_UP);
            long dur = Long.parseLong(duration.toBigInteger().toString());
            BigDecimal inSec = duration.divide(nano);
            if (errorCount.compareTo(BigDecimal.ZERO) == 1) {
                String percent = errorCount.multiply(new BigDecimal(100)).divide(resCount, RoundingMode.HALF_UP).toBigInteger().toString();
                errStr = String.valueOf(CommonUtils.formatNumber((Number)data.errorCount)) + " error(s) " + percent + "%";
            } else {
                errStr = "0 error";
            }
            out.println("\u00a7'Benchmark results:");
            out.println();
            out.println("  \u00a7+" + CommonUtils.formatNumber((Number)data.resCount) + " requests in " + CommonUtils.formatNamoSec((long)total) + ", " + "\u00a7%" + errStr);
            out.println();
            out.println("  Requests per second: \u00a7+" + CommonUtils.formatNumber((Number)reqPer));
            out.println();
            out.println("  Latency: ");
            out.println("    Average: \u00a7+" + CommonUtils.formatNamoSec((long)dur) + " (" + inSec.toPlainString() + " second)");
            if (data.minTime.get() != Long.MAX_VALUE) {
                out.println("    Minimum: \u00a7+" + CommonUtils.formatNamoSec((long)data.minTime.get()));
            }
            if (data.maxTime.get() != Long.MIN_VALUE) {
                out.println("    Maximum: \u00a7+" + CommonUtils.formatNamoSec((long)data.maxTime.get()));
            }
            if (data.cause != null) {
                out.println();
                out.println("\u00a7!Trace of the first faulty response:");
                out.println();
                data.cause.printStackTrace(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
    }

    protected static final class BenchData {
        protected final long startTime;
        protected final ServiceBroker broker;
        protected final CallOptions.Options opts;
        protected final PrintWriter out;
        protected final String action;
        protected final Tree params;
        protected final long num;
        protected final AtomicLong reqCount = new AtomicLong();
        protected final AtomicLong resCount = new AtomicLong();
        protected final AtomicLong errorCount = new AtomicLong();
        protected final AtomicLong sumTime = new AtomicLong();
        protected final AtomicLong minTime = new AtomicLong(Long.MAX_VALUE);
        protected final AtomicLong maxTime = new AtomicLong(Long.MIN_VALUE);
        protected final AtomicBoolean timeout = new AtomicBoolean();
        protected final AtomicBoolean finished = new AtomicBoolean();
        protected Throwable cause;

        protected BenchData(ServiceBroker broker, CallOptions.Options opts, PrintWriter out, String action, Tree params, long num) {
            this.broker = broker;
            this.opts = opts;
            this.out = out;
            this.action = action;
            this.params = params;
            this.num = num;
            this.startTime = System.nanoTime();
        }
    }
}

