/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import services.moleculer.ServiceBroker;
import services.moleculer.context.CallOptions;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;
import services.moleculer.stream.PacketStream;
import services.moleculer.util.CommonUtils;

@Name(value="call")
public class Call
extends Command {
    protected boolean dcall;

    public Call() {
        this.option("load [filename]", "load params from file");
        this.option("stream [filename]", "send a file as stream");
        this.option("save [filename]", "save response to file");
        this.option("timeout <seconds>", "call timeout (default is 10)");
    }

    @Override
    public String getDescription() {
        return "Call an action";
    }

    @Override
    public String getUsage() {
        return "call <actionName> [jsonParams]";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        List<String> knownParams;
        if (parameters[0].startsWith("--")) {
            String cmd = this.dcall ? "dcall" : "call";
            String prefix = this.dcall ? String.valueOf(cmd) + " node1" : cmd;
            out.println("Invalid parameter sequence! Examples of appropriate \"" + cmd + "\" commands:");
            out.println();
            out.println(String.valueOf(prefix) + " $node.actions {\"onlyLocal\":true}");
            out.println(String.valueOf(prefix) + " $node.actions --save /temp/response.json onlyLocal true");
            out.println(String.valueOf(prefix) + " $node.actions --save");
            out.println(String.valueOf(prefix) + " $node.actions --load /temp/request.json");
            out.println(String.valueOf(prefix) + " service.action --stream /temp/data.zip");
            return;
        }
        String nodeID = this.dcall ? parameters[0] : null;
        String action = this.dcall ? parameters[1] : parameters[0];
        Tree flags = this.parseFlags(this.dcall ? 2 : 1, parameters, knownParams = Arrays.asList("load", "stream", "save", "timeout"));
        String load = flags.get("load", "");
        if ((load == null || load.isEmpty()) && flags.get("load") != null) {
            load = String.valueOf(action) + ".params.json";
        }
        String stream = flags.get("stream", "");
        String save = flags.get("save", "");
        if ((save == null || save.isEmpty()) && flags.get("save") != null) {
            save = String.valueOf(action) + ".response.json";
        }
        long timeout = flags.get("timeout", 10L);
        int lastIndex = flags.get("lastIndex", this.dcall ? 1 : 0);
        Tree params = new Tree();
        if (load == null || load.isEmpty()) {
            params = this.getPayload(lastIndex + 1, parameters);
        } else {
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(load);
                    params = CommonUtils.readTree((InputStream)in, (String)"json");
                    in = null;
                }
                catch (Exception e) {
                    out.println("Unable to load file \"" + load + "\"!");
                    out.println();
                    e.printStackTrace(out);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        File file = save == null || save.isEmpty() ? null : new File(save);
        CallOptions.Options opts = CallOptions.timeout((long)(1000L * timeout));
        if (nodeID != null) {
            opts = opts.nodeID(nodeID);
        }
        if (stream == null || stream.isEmpty()) {
            if (this.dcall) {
                out.println("\u00a7!>> Call \"" + action + "\" on \"" + nodeID + "\" with params: " + params.toString("colorized-json", false));
            } else {
                out.println("\u00a7!>> Call \"" + action + "\" with params: " + params.toString("colorized-json", false));
            }
            long start = System.nanoTime();
            Tree rsp2 = broker.call(action, params, opts).waitFor();
            this.dumpResponse(out, rsp2, System.nanoTime() - start, file);
        } else {
            if (this.dcall) {
                out.println("\u00a7!>> Call \"" + action + "\" on \"" + nodeID + "\" with file: " + stream);
            } else {
                out.println("\u00a7!>> Call \"" + action + "\" with file: " + stream);
            }
            PacketStream push = stream != null && !stream.isEmpty() ? broker.createStream() : null;
            long start = System.nanoTime();
            broker.call(action, push, opts).then(rsp -> {
                long duration = System.nanoTime() - start;
                Thread.sleep(100L);
                this.dumpResponse(out, (Tree)rsp, duration, file);
            }).catchError(error -> error.printStackTrace(out));
            if (push != null) {
                push.transferFrom(new File(stream)).then(finished -> {
                    out.println();
                    out.println(String.valueOf(push.getTransferedBytes()) + " bytes transfered to \"" + nodeID + "\".");
                }).catchError(error -> error.printStackTrace(out));
            }
        }
    }

    protected void dumpResponse(PrintWriter out, Tree rsp, long duration, File file) {
        block20: {
            out.println();
            out.println("\u00a7$Execution time: " + CommonUtils.formatNamoSec((long)duration));
            if (rsp == null) {
                out.println();
                out.println("\u00a7%\"null\" response");
            } else if (rsp.getType() == PacketStream.class) {
                PacketStream stream = (PacketStream)rsp.asObject();
                AtomicBoolean first = new AtomicBoolean(true);
                stream.onPacket((bytes, error, closed) -> {
                    block19: {
                        if (bytes != null && bytes.length > 0) {
                            if (file == null) {
                                out.println();
                                out.println("\u00a7'" + bytes.length + " bytes received:");
                                out.println();
                                this.writeHexBytes(out, bytes);
                                out.println();
                            } else {
                                FileOutputStream fo = null;
                                try {
                                    try {
                                        fo = new FileOutputStream(file, !first.get());
                                        first.compareAndSet(true, false);
                                        fo.write(bytes);
                                        fo.flush();
                                        out.println("\u00a7'" + bytes.length + " bytes saved to file \"" + file.getCanonicalPath() + "\".");
                                    }
                                    catch (Exception e) {
                                        out.println("Unable to save response!");
                                        out.println();
                                        e.printStackTrace(out);
                                        if (fo != null) {
                                            try {
                                                fo.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        break block19;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (fo != null) {
                                        try {
                                            fo.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    throw throwable;
                                }
                                if (fo != null) {
                                    try {
                                        fo.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                    }
                    if (error != null) {
                        error.printStackTrace(out);
                    }
                    if (closed) {
                        out.println("Stream closed successfully.");
                    }
                });
            } else if (file == null) {
                out.println();
                out.println("\u00a7'Response:");
                out.println();
                out.println(rsp.toString("colorized-json", true, true));
            } else {
                FileOutputStream fo = null;
                try {
                    try {
                        fo = new FileOutputStream(file);
                        fo.write(rsp.toString("json", true, true).getBytes(StandardCharsets.UTF_8));
                        fo.flush();
                        out.println("Response saved successfully to file \"" + file.getCanonicalPath() + "\".");
                    }
                    catch (Exception e) {
                        out.println("Unable to save response!");
                        out.println();
                        e.printStackTrace(out);
                        if (fo != null) {
                            try {
                                fo.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (fo != null) {
                        try {
                            fo.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (fo != null) {
                    try {
                        fo.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected void writeHexBytes(PrintWriter out, byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            String s = Integer.toHexString(bytes[i] & 0xFF).toUpperCase();
            if (s.length() < 2) {
                out.write(48);
            }
            out.write(s);
            out.write(32);
            if (i > 0) {
                int j = i + 1;
                if (j % 20 == 0) {
                    out.println();
                } else if (j % 5 == 0) {
                    out.write("| ");
                }
            }
            ++i;
        }
    }
}

