/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import services.moleculer.ServiceBroker;
import services.moleculer.cacher.Cacher;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;

@Name(value="clear")
public class Clear
extends Command {
    @Override
    public String getDescription() {
        return "Delete cached entries by pattern";
    }

    @Override
    public String getUsage() {
        return "clear <pattern>";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        Cacher cacher = broker.getConfig().getCacher();
        if (cacher == null) {
            out.println("Unable to clear cache - broker has no cacher module.");
        } else {
            String match = parameters[0];
            cacher.clean(match).then(in -> out.println("\u00a7!>> Cache cleared successfully.")).catchError(cause -> out.println("Unable to remove entries from cache (" + cause + ")!"));
        }
    }
}

