/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;
import services.moleculer.transporter.Transporter;

@Name(value="debug")
public class Debug
extends Command {
    public Debug() {
        this.option("all, -a", "show heartbeat/gossip messages");
    }

    @Override
    public String getDescription() {
        return "Turn on/off debug log of Transporter";
    }

    @Override
    public String getUsage() {
        return "debug <on|off>";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        Transporter transporter = broker.getConfig().getTransporter();
        if (transporter == null) {
            out.println("Debug mode can't be enabled without a Transporter.");
            out.println();
            return;
        }
        List<String> params = Arrays.asList(parameters);
        boolean all = params.contains("--all") || params.contains("-a");
        boolean on = params.contains("on");
        if (on) {
            if (transporter.isDebug() && (!all || transporter.isDebugHeartbeats())) {
                out.println("Debug messages have been enabled earlier.");
            } else {
                out.println("The transporter debug mode has been enabled.");
                if (all) {
                    out.println("Heartbeat/gossip messages will also be displayed.");
                }
                transporter.setDebug(true);
                if (all) {
                    transporter.setDebugHeartbeats(true);
                }
            }
        } else if (!transporter.isDebug() && !transporter.isDebugHeartbeats()) {
            out.println("Debug messages have been disabled earlier.");
        } else {
            transporter.setDebug(false);
            transporter.setDebugHeartbeats(false);
            out.println("The transporter debug mode has been disabled.");
        }
    }
}

