/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;

@Name(value="env")
public class Env
extends Command {
    public Env() {
        this.option("full", "show full-length keys");
    }

    @Override
    public String getDescription() {
        return "Lists of environment properties";
    }

    @Override
    public String getUsage() {
        return "env";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        TextTable table = new TextTable("Key", "Value");
        boolean full = false;
        if (parameters.length > 0) {
            full = "--full".equals(parameters[0]);
        }
        Map<String, String> properties = System.getenv();
        LinkedList<String> list = new LinkedList<String>();
        Iterator<String> keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            list.addLast(keys.next());
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        int n = 0;
        while (n < names.length) {
            String key = names[n];
            String value = properties.get(key);
            if (value == null || value.length() == 0) {
                value = "[undefined]";
            }
            if (!full && key.length() > 23) {
                key = String.valueOf(key.substring(0, 10)) + "..." + key.substring(key.length() - 10, key.length());
            }
            table.addRow(true, key, value);
            ++n;
        }
        out.println(table);
    }
}

