/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;
import services.moleculer.transporter.Transporter;
import services.moleculer.util.CommonUtils;

@Name(value="events")
public class Events
extends Command {
    public Events() {
        this.options.clear();
        this.option("local, -l", "only local event listeners");
        this.option("skipinternal, -i", "skip internal event listeners");
        this.option("details, -d", "print endpoints");
        this.option("all, -a", "list all (offline) event listeners");
    }

    @Override
    public String getDescription() {
        return "List of event listeners";
    }

    @Override
    public String getUsage() {
        return "events [options]";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        List<String> params = Arrays.asList(parameters);
        boolean local = params.contains("--local") || params.contains("-l");
        boolean skipinternal = params.contains("--skipinternal") || params.contains("-i");
        boolean details = params.contains("--details") || params.contains("-d");
        boolean all = params.contains("--all") || params.contains("-a");
        Transporter transporter = broker.getConfig().getTransporter();
        Tree infos = CommonUtils.getNodeInfos((ServiceBroker)broker, (Transporter)transporter);
        String localNodeID = broker.getNodeID();
        HashMap eventMap = new HashMap();
        for (Tree info : infos) {
            String nodeID = info.getName();
            Tree services = info.get("services");
            if (services == null || services.isNull()) continue;
            for (Tree service : services) {
                Tree events = service.get("events");
                if (events == null || events.isNull()) continue;
                for (Tree event : events) {
                    String eventName = event.get("name", "unknown");
                    HashSet nodeSet = (HashSet)eventMap.get(eventName);
                    if (nodeSet == null) {
                        nodeSet = new HashSet();
                        eventMap.put(eventName, nodeSet);
                    }
                    nodeSet.add(nodeID);
                }
            }
        }
        String[] eventNames = new String[eventMap.size()];
        eventMap.keySet().toArray(eventNames);
        Arrays.sort(eventNames, String.CASE_INSENSITIVE_ORDER);
        TextTable table = new TextTable("Event", "Nodes");
        String[] stringArray = eventNames;
        int n = eventNames.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                String nodes;
                HashSet nodeSet;
                ArrayList<String> row;
                block16: {
                    block15: {
                        String eventName;
                        block14: {
                            eventName = stringArray[n2];
                            if (skipinternal && eventName.startsWith("$")) break block13;
                            row = new ArrayList<String>(2);
                            nodeSet = (HashSet)eventMap.get(eventName);
                            if (nodeSet == null) break block13;
                            if (all) break block14;
                            boolean online = false;
                            for (String nodeID : nodeSet) {
                                online = transporter == null ? true : transporter.isOnline(nodeID);
                                if (online) break;
                            }
                            if (!online) break block13;
                        }
                        row.add(eventName);
                        nodes = Integer.toString(nodeSet.size());
                        if (!nodeSet.contains(localNodeID)) break block15;
                        nodes = "(*) " + nodes;
                        break block16;
                    }
                    if (local) break block13;
                }
                row.add(nodes);
                table.addRow(row);
                if (details) {
                    String[] nodeIDArray = new String[nodeSet.size()];
                    nodeSet.toArray(nodeIDArray);
                    Arrays.sort(nodeIDArray, String.CASE_INSENSITIVE_ORDER);
                    String[] stringArray2 = nodeIDArray;
                    int n3 = nodeIDArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String nodeID = stringArray2[n4];
                        if (localNodeID.equals(nodeID)) {
                            table.addRow("", "<local>");
                        } else {
                            table.addRow("", nodeID);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        out.println(table);
    }
}

