/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;

@Name(value="find")
public class Find
extends Command {
    @Override
    public String getDescription() {
        return "Find a class or resource";
    }

    @Override
    public String getUsage() {
        return "find <fullClassName>";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        URL url;
        String name = parameters[0];
        int index = name.indexOf(46);
        if (index != -1) {
            name = String.valueOf(name.replace('.', '/')) + ".class";
        }
        if ((url = this.getClass().getClassLoader().getResource(name)) == null) {
            url = this.getClass().getClassLoader().getResource(parameters[0]);
        }
        out.println("Location of resource:");
        out.println();
        out.print("  ");
        if (url == null) {
            out.println("Resource '" + parameters[0] + "' not found.");
        } else {
            out.println(URLDecoder.decode(url.toString(), "UTF8"));
        }
    }
}

