/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;

@Name(value="gc")
public class Gc
extends Command {
    protected DecimalFormat formatter = new DecimalFormat("#.##");

    @Override
    public String getDescription() {
        return "Invoke garbage collector";
    }

    @Override
    public String getUsage() {
        return "gc";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        long before = runtime.totalMemory() - runtime.freeMemory();
        System.runFinalization();
        System.gc();
        long after = runtime.totalMemory() - runtime.freeMemory();
        long freed = before - after;
        if (freed < 0L) {
            freed = 0L;
        }
        int percent = (int)(100L * freed / before);
        out.println("Garbage collection report:");
        out.println();
        long max = before;
        if (after > max) {
            max = after;
        }
        this.printMemory(out, "  before  - ", before, max, 27);
        this.printMemory(out, "  after   - ", after, max, 27);
        this.printMemory(out, "  freed   - ", freed, max, 27);
        out.print("  percent - ");
        out.print(Integer.toString(percent));
        out.println("%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printMemory(PrintWriter out, String title, long value, long max, int offset) throws Exception {
        StringBuilder tmp = new StringBuilder();
        tmp.append(title);
        tmp.append("\u00a7+");
        DecimalFormat decimalFormat = this.formatter;
        synchronized (decimalFormat) {
            tmp.append(this.formatter.format((double)value / 1024.0 / 1024.0));
        }
        tmp.append(" Mbytes");
        this.printChars(tmp, ' ', offset - tmp.length());
        tmp.append("\u00a7'");
        this.printChars(tmp, '|', (int)((long)(77 - offset) * value / max));
        out.println(tmp.toString());
    }
}

