/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import io.datatree.dom.TreeReaderRegistry;
import io.datatree.dom.TreeWriterRegistry;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import services.moleculer.ServiceBroker;
import services.moleculer.breaker.CircuitBreaker;
import services.moleculer.config.ServiceBrokerConfig;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.serializer.Serializer;
import services.moleculer.service.Name;
import services.moleculer.service.ServiceInvoker;
import services.moleculer.transporter.TcpTransporter;
import services.moleculer.transporter.Transporter;
import services.moleculer.util.CommonUtils;

@Name(value="info")
public class Info
extends Command {
    protected static AtomicReference<String> softwareVersion = new AtomicReference();
    protected static AtomicReference<String> protocolVersion = new AtomicReference();
    protected DecimalFormat formatter = new DecimalFormat("#.##");

    @Override
    public String getDescription() {
        return "Information about the broker";
    }

    @Override
    public String getUsage() {
        return "info";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        String offset;
        Runtime r = Runtime.getRuntime();
        ServiceBrokerConfig cfg = broker.getConfig();
        this.printHeader(out, "General information");
        TextTable table = new TextTable(false, "Name", "Value");
        table.addRow("\u00a7%CPU", ": \u00a7+Arch: " + System.getProperty("os.arch", "unknown") + ", Cores: " + r.availableProcessors());
        int cpuUsage = cfg.getMonitor().getTotalCpuPercent();
        table.addRow("\u00a7%CPU usage", ": \u00a7+" + cpuUsage + "%");
        long total = r.totalMemory();
        long free = r.freeMemory();
        long used = total - free;
        int usedLen = (int)(20L * used / total);
        StringBuilder tmp = new StringBuilder(64);
        tmp.append(": ");
        tmp.append("\u00a7+");
        tmp.append('[');
        tmp.append("\u00a7'");
        if (usedLen < 1) {
            usedLen = 1;
        }
        this.printChars(tmp, '|', usedLen);
        tmp.append("\u00a7+");
        this.printChars(tmp, '-', 20 - usedLen);
        tmp.append("] ");
        tmp.append("\u00a7%");
        DecimalFormat decimalFormat = this.formatter;
        synchronized (decimalFormat) {
            tmp.append(this.formatter.format((double)free / 1024.0 / 1024.0));
        }
        tmp.append(" MB free");
        table.addRow("\u00a7%Heap", tmp.toString());
        table.addRow("\u00a7%OS", ": \u00a7+" + System.getProperty("os.name", "unknown") + " (V" + System.getProperty("os.version", "?") + ')');
        try {
            table.addRow("\u00a7%IP", ": \u00a7+" + InetAddress.getLocalHost().getHostAddress());
        }
        catch (Exception exception) {}
        table.addRow("\u00a7%Hostname", ": \u00a7+" + CommonUtils.getHostName());
        table.addRow("", "");
        table.addRow("\u00a7%Java VM version", ": \u00a7+" + System.getProperty("java.version", "unknown") + " from " + System.getProperty("java.vm.vendor", "unknown vendor"));
        table.addRow("\u00a7%Java VM type", ": \u00a7+" + System.getProperty("java.vm.name", "unknown"));
        table.addRow("\u00a7%Moleculer version", ": \u00a7+" + Info.getSoftwareVersion());
        table.addRow("\u00a7%Protocol version", ": \u00a7+" + Info.getProtocolVersion(broker));
        TimeZone zone = TimeZone.getDefault();
        int currentOffset = zone.getOffset(System.currentTimeMillis());
        if (currentOffset == 0) {
            offset = "+00:00";
        } else {
            long hours = TimeUnit.MILLISECONDS.toHours(currentOffset);
            long minutes = TimeUnit.MILLISECONDS.toMinutes(currentOffset);
            minutes = Math.abs(minutes - TimeUnit.HOURS.toMinutes(hours));
            offset = String.format("%+03d:%02d", hours, Math.abs(minutes));
        }
        table.addRow("", "");
        table.addRow("\u00a7%Current time", ": \u00a7+" + SimpleDateFormat.getDateTimeInstance(2, 2, Locale.US).format(new Date()) + " GMT" + offset + " (" + zone.getDisplayName() + ")");
        out.println(table);
        Transporter t = cfg.getTransporter();
        this.printHeader(out, "Broker information");
        table = new TextTable(false, "Name", "Value");
        String ns = cfg.getNamespace();
        if (ns == null || ns.isEmpty()) {
            table.addRow("\u00a7%Namespace", ": <None>");
        } else {
            table.addRow("\u00a7%Namespace", ": \u00a7+" + ns);
        }
        table.addRow("\u00a7%Node ID", ": \u00a7+" + broker.getNodeID());
        Tree info = cfg.getServiceRegistry().getDescriptor();
        Tree services = info.get("services");
        if (services != null && !services.isNull()) {
            int actionCounter = 0;
            int eventCounter = 0;
            for (Tree service : services) {
                Tree events;
                Tree actions = service.get("actions");
                if (actions != null) {
                    actionCounter += actions.size();
                }
                if ((events = service.get("events")) == null) continue;
                eventCounter += events.size();
            }
            table.addRow("\u00a7%Services", ": \u00a7+" + services.size());
            table.addRow("\u00a7%Actions", ": \u00a7+" + actionCounter);
            table.addRow("\u00a7%Events", ": \u00a7+" + eventCounter);
        } else {
            table.addRow("\u00a7%Services", ": \u00a7+0");
            table.addRow("\u00a7%Actions", ": \u00a7+0");
            table.addRow("\u00a7%Events", ": \u00a7+0");
        }
        table.addRow("", "");
        this.addType(table, "Strategy", cfg.getStrategyFactory());
        this.addType(table, "Cacher", cfg.getCacher());
        if (t == null) {
            table.addRow("\u00a7%Nodes", ": \u00a7$1");
        } else {
            table.addRow("\u00a7%Nodes", ": \u00a7$" + t.getAllNodeIDs().size());
        }
        out.println(table);
        this.printHeader(out, "Broker options");
        table = new TextTable(false, "Name", "Value");
        this.addType(table, "Event bus", cfg.getEventbus());
        this.addType(table, "System monitor", cfg.getMonitor());
        this.addType(table, "Service registry", cfg.getServiceRegistry());
        this.addType(table, "UID generator", cfg.getUidGenerator());
        ServiceInvoker si = cfg.getServiceInvoker();
        if (si instanceof CircuitBreaker) {
            table.addRow("\u00a7%Circuit breaker:", ": \u00a7~true");
            CircuitBreaker cb = (CircuitBreaker)si;
            table.addRow("\u00a7%Max failures", ": \u00a7$" + cb.getMaxErrors());
            table.addRow("\u00a7%Half open time", ": \u00a7$" + cb.getWindowLength());
        } else {
            table.addRow("\u00a7%Circuit breaker:", ": \u00a7~false");
        }
        table.addRow("", "");
        this.addType(table, "Task executor", cfg.getExecutor());
        this.addType(table, "Task scheduler", cfg.getScheduler());
        table.addRow("", "");
        if (t != null) {
            Serializer s = t.getSerializer();
            this.addType(table, "Serializer", s);
            try {
                if (s != null && "JSON".equalsIgnoreCase(s.getFormat())) {
                    String writers;
                    String readers = this.getAPIs(TreeReaderRegistry.getReader((String)"json"), TreeReaderRegistry.getReadersByFormat((String)"json"));
                    if (readers.equals(writers = this.getAPIs(TreeWriterRegistry.getWriter((String)"json"), TreeWriterRegistry.getWritersByFormat((String)"json")))) {
                        table.addRow("\u00a7%JSON implementations", ": \u00a7+" + readers);
                    } else {
                        table.addRow("\u00a7%JSON readers", ": \u00a7+" + readers);
                        table.addRow("\u00a7%JSON writers", ": \u00a7+" + writers);
                    }
                }
            }
            catch (Exception exception) {}
            this.addType(table, "Transporter", t);
            if (t instanceof TcpTransporter) {
                TcpTransporter tt = (TcpTransporter)t;
                table.addRow("\u00a7%Gossip period", ": \u00a7$" + tt.getGossipPeriod());
                table.addRow("\u00a7%Max connections", ": \u00a7$" + tt.getMaxConnections());
                table.addRow("\u00a7%TCP server port", ": \u00a7$" + tt.getCurrentPort());
                table.addRow("\u00a7%UDP broadcasting", ": \u00a7~" + tt.isUdpBroadcast());
                table.addRow("\u00a7%UDP multicasting", ": \u00a7~" + (tt.getUrls() == null || tt.getUrls().length == 0));
                if (tt.getUdpBindAddress() == null) {
                    table.addRow("\u00a7%Broadcast address", ": <auto>");
                } else {
                    table.addRow("\u00a7%Broadcast address", ": \u00a7'" + tt.getUdpBindAddress());
                }
                table.addRow("\u00a7%Multicast address", ": \u00a7'" + tt.getUdpMulticast());
                table.addRow("\u00a7%UDP port", ": \u00a7$" + tt.getUdpPort());
            } else {
                table.addRow("\u00a7%Heartbeat interval", ": \u00a7$" + t.getHeartbeatInterval());
                table.addRow("\u00a7%Heartbeat timeout", ": \u00a7$" + t.getHeartbeatTimeout());
            }
            table.addRow("\u00a7%Offline timeout", ": \u00a7$" + t.getOfflineTimeout());
        } else {
            table.addRow("\u00a7%Transporter", ": <none>");
        }
        table.addRow("\u00a7%Internal services", ": \u00a7~" + cfg.isInternalServices());
        out.println(table);
    }

    protected String getAPIs(Object defaultAPI, Set<String> values) {
        String api = CommonUtils.nameOf((Object)defaultAPI, (boolean)false);
        if (api.startsWith("json")) {
            api = api.substring(4);
        }
        StringBuilder list = new StringBuilder(32);
        for (String name : values) {
            int i = name.lastIndexOf(".Json");
            if (i <= -1) continue;
            if (list.length() > 0) {
                list.append(", ");
            }
            name = name.substring(i + 5);
            list.append(name);
            if (!name.equals(api)) continue;
            list.append(" (*)");
        }
        return list.toString();
    }

    protected void addType(TextTable table, String title, Object component) {
        if (component == null) {
            table.addRow("\u00a7%" + title, "\u00a7%: <none>");
        } else {
            table.addRow("\u00a7%" + title, ": \u00a7'" + CommonUtils.nameOf((Object)component, (boolean)false));
        }
    }

    protected void printHeader(PrintWriter out, String header) {
        header = "\u00a7!  " + header;
        int len = header.length() + 2;
        StringBuilder line = new StringBuilder(len);
        line.append("\u00a7!");
        int i = 0;
        while (i < len) {
            line.append('=');
            ++i;
        }
        out.println(line);
        out.println(header);
        out.println(line);
        out.println();
    }

    public static final String getSoftwareVersion() {
        String version = softwareVersion.get();
        if (version == null) {
            try {
                version = (String)ServiceBroker.class.getField("SOFTWARE_VERSION").get(ServiceBroker.class);
            }
            catch (Throwable throwable) {
                version = "1.2.11";
            }
            softwareVersion.compareAndSet(null, version);
        }
        return version;
    }

    public static final String getProtocolVersion(ServiceBroker broker) {
        String version = protocolVersion.get();
        if (version == null) {
            try {
                version = (String)ServiceBroker.class.getMethod("getProtocolVersion", new Class[0]).invoke((Object)broker, new Object[0]);
            }
            catch (Throwable throwable) {}
            if (version == null) {
                try {
                    version = (String)ServiceBroker.class.getField("PROTOCOL_VERSION").get(ServiceBroker.class);
                }
                catch (Throwable throwable) {}
            }
            if (version == null) {
                version = "4";
            }
            protocolVersion.compareAndSet(null, version);
        }
        return version;
    }
}

