/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.commands.Gc;
import services.moleculer.service.Name;

@Name(value="memory")
public class Memory
extends Gc {
    @Override
    public String getDescription() {
        return "Show memory usage";
    }

    @Override
    public String getUsage() {
        return "memory";
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        out.println("Memory usage:");
        out.println();
        this.printMemory(out, "  total - ", total, total, 27);
        this.printMemory(out, "  used  - ", used, total, 27);
        this.printMemory(out, "  free  - ", free, total, 27);
    }
}

