/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;
import services.moleculer.transporter.Transporter;
import services.moleculer.util.CommonUtils;

@Name(value="nodes")
public class Nodes
extends Command {
    public Nodes() {
        this.option("details, -d", "detailed list");
        this.option("all, -a", "list all (offline) nodes");
        this.option("raw", "print service registry as JSON");
        this.option("save [filename], -a", "save service registry to JSON file");
    }

    @Override
    public String getDescription() {
        return "List of nodes";
    }

    @Override
    public String getUsage() {
        return "nodes [options]";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        List<String> params = Arrays.asList(parameters);
        boolean all = params.contains("--all") || params.contains("-a");
        boolean details = params.contains("--details") || params.contains("-d");
        boolean raw = params.contains("--raw");
        boolean save = params.contains("--save");
        boolean telnet = params.contains("telnet");
        Transporter transporter = broker.getConfig().getTransporter();
        Tree infos = CommonUtils.getNodeInfos((ServiceBroker)broker, (Transporter)transporter);
        String localNodeID = broker.getNodeID();
        if (raw || save) {
            ArrayList<Object> array = new ArrayList<Object>(infos.size());
            for (Tree info : infos) {
                array.add(info.asObject());
            }
            String json = new Tree(array).toString("colorized-json", true, true);
            if (raw) {
                out.println(json);
            } else {
                String filePath = parameters[parameters.length - 1];
                if (filePath.startsWith("--")) {
                    filePath = String.valueOf(System.getProperty("user.home", "")) + "/nodes.json";
                }
                try (FileOutputStream os = null;){
                    File file = new File(filePath);
                    os = new FileOutputStream(file);
                    os.write(json.getBytes(StandardCharsets.UTF_8));
                    os.flush();
                    out.println("\u00a7~>> Node list has been saved to '" + file.getCanonicalPath() + "' file.");
                }
            }
            return;
        }
        TextTable table = telnet ? new TextTable("Node ID", "S.", "V.", "Client", "IP", "State", "CPU") : new TextTable("Node ID", "Services", "Version", "Client", "IP", "State", "CPU");
        for (Tree info : infos) {
            ArrayList<String> row = new ArrayList<String>(7);
            String nodeID = info.getName();
            if (localNodeID.equals(nodeID)) {
                row.add(String.valueOf(nodeID) + " (*)");
            } else {
                row.add(nodeID);
            }
            Tree services = info.get("services");
            row.add(services == null ? "0" : Integer.toString(services.size()));
            row.add(info.get("client.version", "unknown"));
            row.add(info.get("client.type", "unknown"));
            Tree ipList = info.get("ipList");
            int ipCount = ipList == null ? 0 : ipList.size();
            String ip = null;
            if (ipCount > 0) {
                for (Tree ipe : ipList) {
                    String v = ipe.asString();
                    if (ip == null) {
                        ip = v;
                        continue;
                    }
                    if (ip.length() <= v.length()) continue;
                    ip = v;
                }
            }
            if (ip == null) {
                ip = "unknown";
            }
            if (ipCount > 1) {
                ip = String.valueOf(ip) + " (+" + (ipCount - 1) + ')';
            }
            row.add(ip);
            boolean online = transporter == null ? true : transporter.isOnline(nodeID);
            if (!all && !online) continue;
            row.add(online ? "ONLINE" : "OFFLINE");
            if (transporter == null) {
                row.add(String.valueOf(broker.getConfig().getMonitor().getTotalCpuPercent()) + "%");
            } else {
                int cpuUsage = localNodeID.equals(nodeID) ? broker.getConfig().getMonitor().getTotalCpuPercent() : transporter.getCpuUsage(nodeID);
                if (telnet) {
                    row.add(String.valueOf(cpuUsage) + "%");
                } else {
                    int c = cpuUsage / 4;
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    int i = 0;
                    while (i < 20) {
                        sb.append(i <= c ? "#" : "-");
                        ++i;
                    }
                    sb.append("] ");
                    sb.append(String.valueOf(cpuUsage) + "%");
                    row.add(sb.toString());
                }
            }
            table.addRow(row);
            if (!details || services == null) continue;
            for (Tree service : services) {
                table.addRow("", service.get("name", "unknown"), "-", "", "", "", "");
            }
        }
        out.println(table);
    }
}

