/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;
import services.moleculer.util.CommonUtils;

@Name(value="ping")
public class Ping
extends Command {
    @Override
    public String getDescription() {
        return "Sends a PING packet to the specified node";
    }

    @Override
    public String getUsage() {
        return "ping <nodeID>";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        String nodeID = parameters[0];
        out.println("\u00a7!>> Sending PING to '" + nodeID + "' node...");
        long start = System.nanoTime();
        Tree rsp = broker.ping(nodeID).waitFor(10L, TimeUnit.SECONDS);
        long duration = System.nanoTime() - start;
        out.println();
        out.println("\u00a7$Execution time: " + CommonUtils.formatNamoSec((long)duration));
        out.println();
        out.println("\u00a7'Response:");
        out.println();
        if (rsp == null) {
            out.println("'null' response");
        } else {
            out.println(rsp.toString("colorized-json", true, true));
        }
    }
}

