/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;

@Name(value="props")
public class Props
extends Command {
    public Props() {
        this.option("full", "show full-length keys");
    }

    @Override
    public String getDescription() {
        return "List of Java properties";
    }

    @Override
    public String getUsage() {
        return "props";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        TextTable table = new TextTable("Key", "Value");
        boolean full = false;
        if (parameters.length > 0) {
            full = "--full".equals(parameters[0]);
        }
        Properties properties = System.getProperties();
        LinkedList<Object> list = new LinkedList<Object>();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            list.addLast(keys.nextElement());
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        int n = 0;
        while (n < names.length) {
            String value;
            String key = names[n];
            if (key.equals("line.separator")) {
                String sep = properties.getProperty(key);
                value = "";
                int i = 0;
                while (i < sep.length()) {
                    value = String.valueOf(value) + sep.charAt(i) + " ";
                    ++i;
                }
            } else {
                value = properties.getProperty(key);
                if (value == null || value.length() == 0) {
                    value = "[undefined]";
                }
            }
            if (!full && key.length() > 23) {
                key = String.valueOf(key.substring(0, 10)) + "..." + key.substring(key.length() - 10, key.length());
            }
            table.addRow(true, key, value);
            ++n;
        }
        out.println(table);
    }
}

