/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.Repl;
import services.moleculer.service.Name;
import services.moleculer.service.Service;
import services.moleculer.service.ServiceRegistry;
import services.moleculer.util.CommonUtils;

@Name(value="run")
public class Run
extends Command {
    @Override
    public String getDescription() {
        return "Runs commands from a script file";
    }

    @Override
    public String getUsage() {
        return "run <path-to-file>";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 1;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        String line;
        Repl repl;
        String script;
        StringBuilder tmp = new StringBuilder();
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            tmp.append(p).append(' ');
            ++n2;
        }
        String path = tmp.toString().replace('\"', ' ').replace('\'', ' ').trim();
        FileInputStream in = null;
        try {
            try {
                out.println("Loading script file from \"" + path + "\"...");
                in = new FileInputStream(path);
                byte[] bytes = CommonUtils.readFully((InputStream)in);
                script = new String(bytes, StandardCharsets.UTF_8);
                in = null;
                out.println("Script file loaded successfully.");
            }
            catch (Exception e) {
                out.println("Unable to load file \"" + path + "\"!");
                out.println();
                e.printStackTrace(out);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        if ((repl = Run.getService(broker, Repl.class)) == null) {
            out.println("Unable to find REPL Service!");
            out.println();
            return;
        }
        BufferedReader reader = new BufferedReader(new StringReader(script));
        int count = 0;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("*") || line.startsWith("//")) continue;
            out.println(line);
            repl.onCommand(out, line);
            ++count;
        }
        out.println(String.valueOf(count) + " commands executed.");
        out.println();
    }

    private static final <T extends Service> T getService(ServiceBroker broker, Class<T> type) {
        ServiceRegistry registry = broker.getConfig().getServiceRegistry();
        Tree info = registry.getDescriptor();
        for (Tree service : info.get("services")) {
            Service instance;
            String name = service.get("name", "");
            if (name == null || name.isEmpty() || !type.isAssignableFrom((instance = broker.getLocalService(name)).getClass())) continue;
            return (T)instance;
        }
        return null;
    }
}

