/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import io.datatree.Tree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.repl.TextTable;
import services.moleculer.service.Name;
import services.moleculer.transporter.Transporter;
import services.moleculer.util.CommonUtils;

@Name(value="services")
public class Services
extends Command {
    public Services() {
        this.options.clear();
        this.option("local, -l", "only local services");
        this.option("skipinternal, -i", "skip internal services");
        this.option("details, -d", "print endpoints");
        this.option("all, -a", "list all (offline) services");
    }

    @Override
    public String getDescription() {
        return "List of services";
    }

    @Override
    public String getUsage() {
        return "services [options]";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        HashMap configs;
        List<String> params = Arrays.asList(parameters);
        boolean local = params.contains("--local") || params.contains("-l");
        boolean skipinternal = params.contains("--skipinternal") || params.contains("-i");
        boolean details = params.contains("--details") || params.contains("-d");
        boolean all = params.contains("--all") || params.contains("-a");
        Transporter transporter = broker.getConfig().getTransporter();
        Tree infos = CommonUtils.getNodeInfos((ServiceBroker)broker, (Transporter)transporter);
        String localNodeID = broker.getNodeID();
        HashMap<String, HashMap> serviceMap = new HashMap<String, HashMap>(512);
        for (Tree info : infos) {
            String nodeID = info.getName();
            Tree services = info.get("services");
            if (services == null || services.isNull()) continue;
            for (Tree service : services) {
                service.put("nodeID", nodeID);
                String serviceName = service.get("name", "unknown");
                configs = (HashMap)serviceMap.get(serviceName);
                if (configs == null) {
                    configs = new HashMap(64);
                    serviceMap.put(serviceName, configs);
                }
                configs.put(nodeID, service);
            }
        }
        String[] serviceNames = new String[serviceMap.size()];
        serviceMap.keySet().toArray(serviceNames);
        Arrays.sort(serviceNames, String.CASE_INSENSITIVE_ORDER);
        TextTable table = new TextTable("Service", "Version", "State", "Actions", "Events", "Nodes");
        String[] stringArray = serviceNames;
        int n = serviceNames.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                String nodes;
                boolean online;
                ArrayList<String> row;
                block19: {
                    block18: {
                        String serviceName = stringArray[n2];
                        if (skipinternal && serviceName.startsWith("$")) break block17;
                        row = new ArrayList<String>(6);
                        configs = (HashMap)serviceMap.get(serviceName);
                        if (configs == null) break block17;
                        row.add(serviceName);
                        row.add("-");
                        online = false;
                        for (Tree config : configs.values()) {
                            String nodeID = config.get("nodeID", localNodeID);
                            if (transporter == null) {
                                online = true;
                                break;
                            }
                            online = transporter.isOnline(nodeID);
                            if (online) break;
                        }
                        if (!all && !online) break block17;
                        row.add(online ? "OK" : "FAILED");
                        HashSet<String> actionNames = new HashSet<String>();
                        for (Tree config : configs.values()) {
                            Tree actions = config.get("actions");
                            if (actions == null) continue;
                            Iterator iterator = actions.iterator();
                            while (iterator.hasNext()) {
                                Tree action = (Tree)iterator.next();
                                actionNames.add(action.get("name", "unknown"));
                            }
                        }
                        row.add(Integer.toString(actionNames.size()));
                        HashSet<String> eventNames = new HashSet<String>();
                        for (Tree config : configs.values()) {
                            Tree events = config.get("events");
                            if (events == null) continue;
                            for (Tree action : events) {
                                eventNames.add(action.get("name", "unknown"));
                            }
                        }
                        row.add(Integer.toString(eventNames.size()));
                        nodes = Integer.toString(configs.size());
                        if (!configs.containsKey(localNodeID)) break block18;
                        nodes = "(*) " + nodes;
                        break block19;
                    }
                    if (local) break block17;
                }
                row.add(nodes);
                table.addRow(row);
                if (details) {
                    String[] nodeIDArray = new String[configs.size()];
                    configs.keySet().toArray(nodeIDArray);
                    Arrays.sort(nodeIDArray, String.CASE_INSENSITIVE_ORDER);
                    String[] stringArray2 = nodeIDArray;
                    int n3 = nodeIDArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String nodeID = stringArray2[n4];
                        if (localNodeID.equals(nodeID)) {
                            table.addRow("", "", "OK", "", "", "<local>");
                        } else {
                            online = transporter == null ? true : transporter.isOnline(nodeID);
                            table.addRow("", "", online ? "OK" : "FAILED", "", "", nodeID);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        out.println(table);
    }
}

