/*
 * Decompiled with CFR 0.152.
 */
package services.moleculer.repl.commands;

import java.io.PrintWriter;
import services.moleculer.ServiceBroker;
import services.moleculer.repl.Command;
import services.moleculer.service.Name;

@Name(value="threads")
public class Threads
extends Command {
    private String newLine = System.getProperty("line.separator", "\r\n");

    @Override
    public String getDescription() {
        return "List of threads";
    }

    @Override
    public String getUsage() {
        return "threads";
    }

    @Override
    public int getNumberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void onCommand(ServiceBroker broker, PrintWriter out, String[] parameters) throws Exception {
        ThreadGroup mainGroup = Thread.currentThread().getThreadGroup();
        while (mainGroup.getParent() != null) {
            mainGroup = mainGroup.getParent();
        }
        StringBuilder writer = new StringBuilder();
        int i = 0;
        while (i < 10) {
            try {
                writer.setLength(0);
                writer.append("Thread hierarchy:");
                writer.append(this.newLine);
                writer.append(this.newLine);
                this.printThreadGroup(writer, mainGroup, 2);
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                    throw new ThreadDeath();
                }
                ++i;
            }
        }
        out.print(writer.toString());
    }

    protected void printThreadGroup(StringBuilder tmp, ThreadGroup group, int tabs) throws Exception {
        this.printChars(tmp, ' ', tabs);
        tmp.append("\u00a7!");
        tmp.append("Group: ");
        tmp.append(group.getName());
        if (group.isDaemon()) {
            tmp.append("\u00a7%");
            tmp.append(" (Daemon)");
        }
        tmp.append(this.newLine);
        ++tabs;
        int max = group.activeCount() + 50;
        Thread[] subThreads = new Thread[max];
        max = group.enumerate(subThreads, false);
        int n = 0;
        while (n < max) {
            Thread thread = subThreads[n];
            String name = thread.getName();
            this.printChars(tmp, ' ', tabs);
            if (thread.isDaemon() || name.equals("DestroyJavaVM")) {
                tmp.append("\u00a7%");
            } else {
                tmp.append("\u00a7'");
            }
            tmp.append(Integer.toString(thread.getPriority()));
            tmp.append(' ');
            tmp.append(name);
            if (name.startsWith("Thread")) {
                tmp.append(" <");
                tmp.append(thread.getClass().getName());
                tmp.append('>');
            }
            tmp.append("\u00a7%");
            if (thread.isDaemon()) {
                tmp.append(" (Daemon)");
            }
            if (!thread.isAlive()) {
                tmp.append(" (Dead)");
            }
            if (thread.isInterrupted()) {
                tmp.append(" (Interrupted)");
            }
            tmp.append(this.newLine);
            ++n;
        }
        max = group.activeGroupCount() + 50;
        ThreadGroup[] subGroups = new ThreadGroup[max];
        max = group.enumerate(subGroups, false);
        tabs += 2;
        int idx = 0;
        while (idx < max) {
            ThreadGroup tg = subGroups[idx];
            this.printThreadGroup(tmp, tg, tabs);
            ++idx;
        }
    }
}

